/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.capability;

import com.hbm.capability.HbmLivingCapability;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.AdvancementManager;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class HbmLivingProps {
    public static final UUID digamma_UUID = UUID.fromString("2a3d8aec-5ab9-4218-9b8b-ca812bdf378b");

    public static HbmLivingCapability.IEntityHbmProps getData(EntityLivingBase entity) {
        return entity.hasCapability(HbmLivingCapability.EntityHbmPropsProvider.ENT_HBM_PROPS_CAP, null) ? (HbmLivingCapability.IEntityHbmProps)entity.getCapability(HbmLivingCapability.EntityHbmPropsProvider.ENT_HBM_PROPS_CAP, null) : HbmLivingCapability.EntityHbmPropsProvider.DUMMY;
    }

    public static float getRadiation(EntityLivingBase entity) {
        return HbmLivingProps.getData(entity).getRads();
    }

    public static void setRadiation(EntityLivingBase entity, float rad) {
        HbmLivingProps.getData(entity).setRads(rad);
    }

    public static void incrementRadiation(EntityLivingBase entity, float rad) {
        float radiation = HbmLivingProps.getRadiation(entity) + rad;
        if (radiation > 2.5E7f) {
            radiation = 2.5E7f;
        }
        if (radiation < 0.0f) {
            radiation = 0.0f;
        }
        HbmLivingProps.setRadiation(entity, radiation);
    }

    public static float getNeutron(EntityLivingBase entity) {
        return HbmLivingProps.getData(entity).getNeutrons();
    }

    public static void setNeutron(EntityLivingBase entity, float rad) {
        HbmLivingProps.getData(entity).setNeutrons(rad);
    }

    public static float getRadEnv(EntityLivingBase entity) {
        return HbmLivingProps.getData(entity).getRadsEnv();
    }

    public static void setRadEnv(EntityLivingBase entity, float rad) {
        HbmLivingProps.getData(entity).setRadsEnv(rad);
    }

    public static float getRadBuf(EntityLivingBase entity) {
        return HbmLivingProps.getData(entity).getRadBuf();
    }

    public static void setRadBuf(EntityLivingBase entity, float rad) {
        HbmLivingProps.getData(entity).setRadBuf(rad);
    }

    public static float getDigamma(EntityLivingBase entity) {
        return HbmLivingProps.getData(entity).getDigamma();
    }

    public static void setDigamma(EntityLivingBase entity, float digamma) {
        HbmLivingProps.getData(entity).setDigamma(digamma);
        float healthMod = (float)Math.pow(0.5, digamma) - 1.0f;
        IAttributeInstance attributeinstance = entity.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
        try {
            attributeinstance.func_111124_b(attributeinstance.func_111127_a(digamma_UUID));
        }
        catch (Exception exception) {
            // empty catch block
        }
        attributeinstance.func_111121_a(new AttributeModifier(digamma_UUID, "digamma", (double)healthMod, 2));
        int s = (int)(digamma * 6.0f);
        if (s > 1) {
            NBTTagCompound shake = new NBTTagCompound();
            shake.func_74778_a("type", "justTilt");
            shake.func_74768_a("time", s);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(shake, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 50.0));
        }
        if ((entity.func_110138_aP() <= 0.0f || digamma >= 10.0f) && entity.func_70089_S()) {
            entity.func_110149_m(0.0f);
            entity.func_70097_a(ModDamageSource.digamma, 5000000.0f);
            entity.func_70606_j(0.0f);
            entity.func_70645_a(ModDamageSource.digamma);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "sweat");
            data.func_74768_a("count", 50);
            data.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150425_aM));
            data.func_74768_a("entity", entity.func_145782_y());
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 50.0));
        }
        if (entity instanceof EntityPlayer) {
            float di = HbmLivingProps.getData(entity).getDigamma();
            if (di > 0.0f) {
                AdvancementManager.grantAchievement((EntityPlayer)entity, AdvancementManager.digammaSee);
            }
            if (di >= 2.0f) {
                AdvancementManager.grantAchievement((EntityPlayer)entity, AdvancementManager.digammaFeel);
            }
            if (di >= 10.0f) {
                AdvancementManager.grantAchievement((EntityPlayer)entity, AdvancementManager.digammaKnow);
            }
        }
    }

    public static void incrementDigamma(EntityLivingBase entity, float digamma) {
        float dRad = HbmLivingProps.getDigamma(entity) + digamma;
        if (dRad > 10.0f) {
            dRad = 10.0f;
        }
        if (dRad < 0.0f) {
            dRad = 0.0f;
        }
        HbmLivingProps.setDigamma(entity, dRad);
    }

    public static int getAsbestos(EntityLivingBase entity) {
        return HbmLivingProps.getData(entity).getAsbestos();
    }

    public static void setAsbestos(EntityLivingBase entity, int asbestos) {
        HbmLivingProps.getData(entity).setAsbestos(asbestos);
        if (asbestos >= 72000) {
            HbmLivingProps.getData(entity).setAsbestos(0);
            entity.func_70097_a(ModDamageSource.asbestos, 1000.0f);
        }
    }

    public static void incrementAsbestos(EntityLivingBase entity, float asbestos) {
        HbmLivingProps.incrementAsbestos(entity, Library.getStatisticalInt(entity.field_70170_p.field_73012_v, asbestos));
    }

    public static void incrementAsbestos(EntityLivingBase entity, int asbestos) {
        HbmLivingProps.setAsbestos(entity, HbmLivingProps.getAsbestos(entity) + asbestos);
    }

    public static void addCont(EntityLivingBase entity, ContaminationEffect cont) {
        HbmLivingProps.getData(entity).getContaminationEffectList().add(cont);
    }

    public static int getBlackLung(EntityLivingBase entity) {
        return HbmLivingProps.getData(entity).getBlacklung();
    }

    public static void setBlackLung(EntityLivingBase entity, int blacklung) {
        HbmLivingProps.getData(entity).setBlacklung(blacklung);
        if (blacklung >= 72000) {
            HbmLivingProps.getData(entity).setBlacklung(0);
            entity.func_70097_a(ModDamageSource.blacklung, 1000.0f);
        }
    }

    public static void incrementBlackLung(EntityLivingBase entity, float blacklung) {
        HbmLivingProps.incrementBlackLung(entity, Library.getStatisticalInt(entity.field_70170_p.field_73012_v, blacklung));
    }

    public static void incrementBlackLung(EntityLivingBase entity, int blacklung) {
        HbmLivingProps.setBlackLung(entity, HbmLivingProps.getBlackLung(entity) + blacklung);
    }

    public static int getTimer(EntityLivingBase entity) {
        return HbmLivingProps.getData(entity).getBombTimer();
    }

    public static void setTimer(EntityLivingBase entity, int bombTimer) {
        HbmLivingProps.getData(entity).setBombTimer(bombTimer);
    }

    public static int getContagion(EntityLivingBase entity) {
        return HbmLivingProps.getData(entity).getContagion();
    }

    public static void setContagion(EntityLivingBase entity, int contageon) {
        HbmLivingProps.getData(entity).setContagion(contageon);
    }

    public static List<ContaminationEffect> getCont(EntityLivingBase e) {
        return HbmLivingProps.getData(e).getContaminationEffectList();
    }

    public static class ContaminationEffect {
        public float maxRad;
        public int maxTime;
        public int time;
        public boolean ignoreArmor;

        public ContaminationEffect(float rad, int time, boolean ignoreArmor) {
            this.maxRad = rad;
            this.maxTime = this.time = time;
            this.ignoreArmor = ignoreArmor;
        }

        public float getRad() {
            return this.maxRad * ((float)this.time / (float)this.maxTime);
        }

        public void save(NBTTagCompound nbt, int index) {
            NBTTagCompound me = new NBTTagCompound();
            me.func_74776_a("maxRad", this.maxRad);
            me.func_74768_a("maxTime", this.maxTime);
            me.func_74768_a("time", this.time);
            me.func_74757_a("ignoreArmor", this.ignoreArmor);
            nbt.func_74782_a("cont_" + index, (NBTBase)me);
        }

        public static ContaminationEffect load(NBTTagCompound nbt, int index) {
            NBTTagCompound me = (NBTTagCompound)nbt.func_74781_a("cont_" + index);
            float maxRad = me.func_74760_g("maxRad");
            int maxTime = nbt.func_74762_e("maxTime");
            int time = nbt.func_74762_e("time");
            boolean ignoreArmor = nbt.func_74767_n("ignoreArmor");
            ContaminationEffect effect = new ContaminationEffect(maxRad, maxTime, ignoreArmor);
            effect.time = time;
            return effect;
        }
    }
}

