/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.block.ICrucibleAcceptor;
import api.hbm.block.IToolable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.material.Mats;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemScraps;
import com.hbm.items.tool.ItemTooling;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.machine.TileEntityFoundryOutlet;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class FoundryOutlet
extends BlockContainer
implements ICrucibleAcceptor,
ILookOverlay,
IToolable {
    public static AxisAlignedBB[] boxes = new AxisAlignedBB[EnumFacing.field_82609_l.length];
    public static final PropertyDirection FACING;

    public FoundryOutlet(String s) {
        super(Material.field_151576_e);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_149672_a(SoundType.field_185852_e);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return boxes[((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal()];
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityFoundryOutlet();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            Mats.MaterialStack mat;
            ItemTooling tool;
            if (player.func_184586_b(hand).func_77973_b() instanceof ItemTooling && ((tool = (ItemTooling)player.func_184586_b(hand).func_77973_b()).getType() == IToolable.ToolType.SCREWDRIVER || tool.getType() == IToolable.ToolType.HAND_DRILL)) {
                return false;
            }
            TileEntityFoundryOutlet tile = (TileEntityFoundryOutlet)world.func_175625_s(pos);
            boolean didSomething = false;
            if (player.func_184586_b(hand).func_190926_b()) {
                tile.invertRedstone = !tile.invertRedstone;
                didSomething = true;
            } else if (player.func_184586_b(hand).func_77973_b() == ModItems.scraps && (mat = ItemScraps.getMats(player.func_184586_b(hand))) != null) {
                tile.filter = mat.material;
                didSomething = true;
            }
            if (didSomething) {
                tile.func_70296_d();
                world.markAndNotifyBlock(pos, world.func_175726_f(pos), state, state, 2);
            }
        }
        return true;
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, EnumFacing side, float fX, float fY, float fZ, EnumHand hand, IToolable.ToolType tool) {
        if (tool == IToolable.ToolType.SCREWDRIVER || tool == IToolable.ToolType.HAND_DRILL) {
            if (world.field_72995_K) {
                return true;
            }
            BlockPos pos = new BlockPos(x, y, z);
            TileEntityFoundryOutlet tile = (TileEntityFoundryOutlet)world.func_175625_s(pos);
            if (tool == IToolable.ToolType.SCREWDRIVER) {
                tile.filter = null;
                tile.invertFilter = false;
            } else if (tool == IToolable.ToolType.HAND_DRILL) {
                tile.invertFilter = !tile.invertFilter;
            }
            tile.func_70296_d();
            IBlockState state = world.func_180495_p(pos);
            world.markAndNotifyBlock(pos, world.func_175726_f(pos), state, state, 2);
            player.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean canAcceptPartialPour(World world, BlockPos p, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        return false;
    }

    @Override
    public Mats.MaterialStack pour(World world, BlockPos p, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        return stack;
    }

    @Override
    public boolean canAcceptPartialFlow(World world, BlockPos p, ForgeDirection side, Mats.MaterialStack stack) {
        return ((ICrucibleAcceptor)world.func_175625_s(p)).canAcceptPartialFlow(world, p, side, stack);
    }

    @Override
    public Mats.MaterialStack flow(World world, BlockPos p, ForgeDirection side, Mats.MaterialStack stack) {
        return ((ICrucibleAcceptor)world.func_175625_s(p)).flow(world, p, side, stack);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntityFoundryOutlet outlet = (TileEntityFoundryOutlet)world.func_175625_s(new BlockPos(x, y, z));
        ArrayList<String> text = new ArrayList<String>();
        if (outlet.filter != null) {
            text.add("\u00a7e" + I18nUtil.resolveKey("foundry.filter", outlet.filter.names[0]));
        }
        if (outlet.invertFilter) {
            text.add("\u00a7e" + I18nUtil.resolveKey("foundry.invertFilter", new Object[0]));
        }
        if (outlet.invertRedstone) {
            text.add("\u00a72" + I18nUtil.resolveKey("foundry.inverted", new Object[0]));
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFF4000, 0x401000, text);
    }

    static {
        FoundryOutlet.boxes[EnumFacing.WEST.ordinal()] = new AxisAlignedBB(0.625, 0.0, 0.3125, 1.0, 0.5, 0.6875);
        FoundryOutlet.boxes[EnumFacing.EAST.ordinal()] = new AxisAlignedBB(0.0, 0.0, 0.3125, 0.375, 0.5, 0.6875);
        FoundryOutlet.boxes[EnumFacing.NORTH.ordinal()] = new AxisAlignedBB(0.3125, 0.0, 0.625, 0.6875, 0.5, 1.0);
        FoundryOutlet.boxes[EnumFacing.SOUTH.ordinal()] = new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 0.5, 0.375);
        FACING = BlockHorizontal.field_185512_D;
    }
}

