/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.util;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.EnumDifficulty;
import xaero.common.minimap.MinimapProcessor;

public class RadarUtils {
    public static double getMaxDistance(MinimapProcessor minimap, boolean circle, double scaleFactor) {
        int cullingSize = minimap.getMinimapSize(scaleFactor) / 2 + 48;
        if (!circle) {
            cullingSize = (int)((double)cullingSize * Math.sqrt(2.0));
        }
        return (double)(cullingSize * cullingSize) / (minimap.getMinimapZoom() * minimap.getMinimapZoom());
    }

    public static boolean isHostileException(Entity e) {
        return false;
    }

    public static boolean isTamed(Entity e, EntityPlayer p) {
        if (e instanceof EntityTameable) {
            EntityTameable tameable = (EntityTameable)e;
            return tameable.func_70909_n() && p.func_110124_au().equals(tameable.func_184753_b());
        }
        if (e instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)e;
            return horse.func_110248_bS() && p.func_110124_au().equals(horse.func_184780_dh());
        }
        return false;
    }

    public static boolean isHostile(Entity e) {
        if (Minecraft.func_71410_x().field_71441_e.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return false;
        }
        if (RadarUtils.isHostileException(e)) {
            return false;
        }
        return e instanceof EntityMob || e instanceof IMob || e.func_184176_by() == SoundCategory.HOSTILE;
    }

    public static String getCustomName(Entity e, boolean nullable) {
        if (e.func_145818_k_()) {
            return e.func_95999_t();
        }
        return nullable ? null : "{non-plain}";
    }
}

