/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.form.model.part;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import org.lwjgl.opengl.GL11;
import xaero.common.misc.Misc;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.creator.render.form.model.part.ModelPartUtil;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelPartRenderTrace;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.hud.minimap.radar.icon.definition.form.model.config.RadarIconModelConfig;

public class RadarIconModelPartPrerenderer {
    public void renderPart(ModelRenderer part, ModelRenderer mainPart, Parameters parameters) {
        if (part == null) {
            return;
        }
        if (parameters.renderedDest.contains(part)) {
            return;
        }
        ModelPartRenderTrace renderInfo = parameters.mrt.getModelPartRenderInfo(part);
        if (renderInfo == null) {
            return;
        }
        if (!ModelPartUtil.hasCubes(part)) {
            return;
        }
        boolean showModelBU = part.field_78806_j;
        boolean isHiddenBU = part.field_78807_k;
        float centerPointX = mainPart.field_78800_c;
        float centerPointY = mainPart.field_78797_d;
        float centerPointZ = mainPart.field_78798_e;
        ModelBox biggestMainPartCuboid = ModelPartUtil.getBiggestCuboid(mainPart);
        if (biggestMainPartCuboid != null) {
            centerPointY += (biggestMainPartCuboid.field_78249_e + biggestMainPartCuboid.field_78250_b) / 2.0f;
            centerPointZ += (biggestMainPartCuboid.field_78246_f + biggestMainPartCuboid.field_78251_c) / 2.0f;
        }
        float xRotBU = 0.0f;
        float yRotBU = 0.0f;
        float zRotBU = 0.0f;
        if (parameters.config.modelPartsRotationReset) {
            xRotBU = part.field_78795_f;
            yRotBU = part.field_78796_g;
            zRotBU = part.field_78808_h;
            part.field_78795_f = 0.0f;
            part.field_78796_g = 0.0f;
            part.field_78808_h = 0.0f;
        }
        part.field_78806_j = true;
        part.field_78807_k = false;
        float xBU = part.field_78800_c;
        float yBU = part.field_78797_d;
        float zBU = part.field_78798_e;
        GlStateManager.func_179131_c((float)renderInfo.red, (float)renderInfo.green, (float)renderInfo.blue, (float)renderInfo.alpha);
        part.func_78793_a(part.field_78800_c - centerPointX, part.field_78797_d - centerPointY, part.field_78798_e - centerPointZ);
        try {
            part.func_78785_a(0.0625f);
            if (renderInfo.alpha > 0.0f) {
                parameters.renderedDest.add(part);
            }
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.info("Exception when rendering entity part. " + part + " " + t.getMessage());
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        part.field_78800_c = xBU;
        part.field_78797_d = yBU;
        part.field_78798_e = zBU;
        while (GL11.glGetError() != 0) {
        }
        if (parameters.config.modelPartsRotationReset) {
            part.field_78795_f = xRotBU;
            part.field_78796_g = yRotBU;
            part.field_78808_h = zRotBU;
        }
        part.field_78806_j = showModelBU;
        part.field_78807_k = isHiddenBU;
    }

    public <T extends Entity> ModelRenderer renderDeclaredMethod(Method method, ModelBase model, ModelRenderer mainPart, Parameters parameters) {
        if (method == null) {
            return mainPart;
        }
        return this.renderPartsIterable((Iterable)Misc.getReflectMethodValue(model, method, new Object[0]), mainPart, parameters);
    }

    public ModelRenderer renderPartsIterable(Iterable<ModelRenderer> parts, ModelRenderer mainPart, Parameters parameters) {
        if (parts == null) {
            return mainPart;
        }
        Iterator<ModelRenderer> partsIterator = parts.iterator();
        if (!partsIterator.hasNext()) {
            return mainPart;
        }
        if (mainPart == null) {
            mainPart = partsIterator.next();
            this.renderPart(mainPart, mainPart, parameters);
        }
        while (partsIterator.hasNext()) {
            this.renderPart(partsIterator.next(), mainPart, parameters);
        }
        return mainPart;
    }

    public static class Parameters {
        public final RadarIconModelConfig config;
        public final ModelRenderTrace mrt;
        public final List<ModelRenderer> renderedDest;

        public Parameters(RadarIconModelConfig config, ModelRenderTrace mrt, List<ModelRenderer> renderedDest) {
            this.config = config;
            this.mrt = mrt;
            this.renderedDest = renderedDest;
        }
    }
}

