/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.info.widget;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import xaero.common.HudMod;
import xaero.common.gui.GuiActionButton;
import xaero.hud.minimap.info.InfoDisplay;

public abstract class InfoDisplayCycleButton
extends GuiActionButton {
    private int currentIndex;
    private final Consumer<GuiButton> action;

    protected InfoDisplayCycleButton(int currentIndex, int x, int y, int w, int h, String message, Consumer<GuiButton> action) {
        super(x, y, w, h, message);
        this.currentIndex = currentIndex;
        this.action = action;
    }

    @Override
    protected void onPress() {
        this.action.accept(this);
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            this.press();
            return true;
        }
        return false;
    }

    public static class Builder<T> {
        private int x;
        private int y;
        private int w;
        private int h;
        private List<T> values;
        private List<ITextComponent> valueNames;
        private InfoDisplay<T> infoDisplay;

        protected Builder() {
        }

        public Builder<T> setDefault() {
            this.setBounds(0, 0, 0, 0);
            this.setValues(null, null);
            this.setInfoDisplay(null);
            return this;
        }

        public Builder<T> setBounds(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            return this;
        }

        public Builder<T> setValues(List<T> values, List<ITextComponent> valueNames) {
            if (values == null != (valueNames == null)) {
                throw new IllegalArgumentException();
            }
            if (values != null && values.size() != valueNames.size()) {
                throw new IllegalArgumentException();
            }
            this.values = values;
            this.valueNames = valueNames;
            return this;
        }

        public Builder<T> setInfoDisplay(InfoDisplay<T> infoDisplay) {
            this.infoDisplay = infoDisplay;
            return this;
        }

        public InfoDisplayCycleButton build() {
            if (this.w == 0 || this.h == 0 || this.values == null || this.infoDisplay == null) {
                throw new IllegalStateException();
            }
            int currentStateIndex = this.values.indexOf(this.infoDisplay.getState());
            if (currentStateIndex < 0) {
                this.infoDisplay.setState(this.values.get(0));
                currentStateIndex = 0;
            }
            Consumer<GuiButton> action = new Consumer<GuiButton>(){

                @Override
                public void accept(GuiButton b) {
                    InfoDisplayCycleButton cycleButton = (InfoDisplayCycleButton)b;
                    if (GuiScreen.func_146272_n()) {
                        cycleButton.currentIndex--;
                        if (cycleButton.currentIndex < 0) {
                            cycleButton.currentIndex = Builder.this.values.size() - 1;
                        }
                    } else {
                        cycleButton.currentIndex = (cycleButton.currentIndex + 1) % Builder.this.values.size();
                    }
                    Builder.this.infoDisplay.setState(Builder.this.values.get(cycleButton.currentIndex));
                    cycleButton.field_146126_j = ((ITextComponent)Builder.this.valueNames.get(cycleButton.currentIndex)).func_150254_d();
                    try {
                        HudMod.INSTANCE.getSettings().saveSettings();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            return new xaero.common.minimap.info.widget.InfoDisplayCycleButton(currentStateIndex, this.x, this.y, this.w, this.h, this.valueNames.get(currentStateIndex).func_150254_d(), action);
        }

        public static <T> Builder<T> begin() {
            return new Builder<T>().setDefault();
        }
    }
}

