/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.info;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.biome.Biome;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.info.InfoDisplay;
import xaero.hud.minimap.info.codec.InfoDisplayCommonStateCodecs;
import xaero.hud.minimap.info.render.compile.InfoDisplayCompiler;
import xaero.hud.minimap.info.render.compile.InfoDisplayOnCompile;
import xaero.hud.minimap.info.widget.InfoDisplayCommonWidgetFactories;
import xaero.hud.minimap.info.widget.InfoDisplayCycleWidgetFactory;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.MinimapWorldManager;

public class BuiltInInfoDisplays {
    private static List<InfoDisplay<?>> ALL = new ArrayList();
    public static final InfoDisplay<Boolean> COORDINATES = InfoDisplay.Builder.begin().setId("coords").setName((ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_coords", new Object[0])).setDefaultState(true).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler(new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, MinimapSession session, int availableWidth, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            String coords = playerPos.func_177958_n() + ", " + playerPos.func_177956_o() + ", " + playerPos.func_177952_p();
            if (Minecraft.func_71410_x().field_71466_p.func_78256_a(coords) >= availableWidth) {
                String stringLevel = "" + playerPos.func_177956_o();
                coords = playerPos.func_177958_n() + ", " + playerPos.func_177952_p();
                compiler.addLine(coords);
                compiler.addLine(stringLevel);
            } else {
                compiler.addLine(coords);
            }
        }
    }).setDestination(new Consumer<InfoDisplay<?>>(){

        @Override
        public void accept(InfoDisplay<?> infoDisplay) {
            ALL.add(infoDisplay);
        }
    }).build();
    public static final InfoDisplay<Boolean> OVERWORLD_COORDINATES = InfoDisplay.Builder.begin().setId("overworld_coords").setName((ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_overworld_coords", new Object[0])).setDefaultState(false).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler(new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, MinimapSession session, int availableWidth, BlockPos playerPos) {
            double coordinateScale;
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            double d = coordinateScale = mc.field_71441_e.field_73011_w.func_186058_p() == DimensionType.NETHER ? 8.0 : 1.0;
            if (coordinateScale == 1.0) {
                return;
            }
            int overworldPlayerX = MathHelper.func_76128_c((double)((double)playerPos.func_177958_n() * coordinateScale));
            int overworldPlayerZ = MathHelper.func_76128_c((double)((double)playerPos.func_177952_p() * coordinateScale));
            String coords = "Xo: " + overworldPlayerX + ", Zo: " + overworldPlayerZ;
            compiler.addWords(coords);
        }
    }).setDestination(new Consumer<InfoDisplay<?>>(){

        @Override
        public void accept(InfoDisplay<?> infoDisplay) {
            ALL.add(infoDisplay);
        }
    }).build();
    public static final InfoDisplay<Boolean> CHUNK_COORDINATES = InfoDisplay.Builder.begin().setId("chunk_coords").setName((ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_chunk_coords", new Object[0])).setDefaultState(false).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler(new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, MinimapSession session, int availableWidth, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            int chunkX = playerPos.func_177958_n() >> 4;
            int chunkZ = playerPos.func_177952_p() >> 4;
            int insideX = playerPos.func_177958_n() & 0xF;
            int insideZ = playerPos.func_177952_p() & 0xF;
            String coords = "C " + chunkX + ", " + chunkZ + " (" + insideX + "; " + insideZ + ")";
            compiler.addWords(coords);
        }
    }).setDestination(new Consumer<InfoDisplay<?>>(){

        @Override
        public void accept(InfoDisplay<?> infoDisplay) {
            ALL.add(infoDisplay);
        }
    }).build();
    public static final InfoDisplay<Boolean> ANGLES = InfoDisplay.Builder.begin().setId("angles").setName((ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_angles", new Object[0])).setDefaultState(false).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler(new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, MinimapSession session, int availableWidth, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            compiler.addLine((ITextComponent)new TextComponentString(String.format("%.1f / %.1f", Float.valueOf(MathHelper.func_76142_g((float)mc.func_175606_aa().field_70177_z)), Float.valueOf(MathHelper.func_76142_g((float)mc.func_175606_aa().field_70125_A)))));
        }
    }).setDestination(new Consumer<InfoDisplay<?>>(){

        @Override
        public void accept(InfoDisplay<?> infoDisplay) {
            ALL.add(infoDisplay);
        }
    }).build();
    public static final InfoDisplay<Boolean> DIMENSION = InfoDisplay.Builder.begin().setId("dimension").setName((ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_dimension", new Object[0])).setDefaultState(false).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler(new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, MinimapSession session, int availableWidth, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            int dimensionId = mc.field_71441_e.field_73011_w.getDimension();
            DimensionType dimensionType = mc.field_71441_e.field_73011_w.func_186058_p();
            if (dimensionType != null) {
                String dimensionName = String.format("%s (%d)", dimensionType.func_186065_b(), dimensionId);
                compiler.addLine(dimensionName);
            }
        }
    }).setDestination(new Consumer<InfoDisplay<?>>(){

        @Override
        public void accept(InfoDisplay<?> infoDisplay) {
            ALL.add(infoDisplay);
        }
    }).build();
    public static final InfoDisplay<Boolean> BIOME = InfoDisplay.Builder.begin().setId("biome").setName((ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_biome", new Object[0])).setDefaultState(false).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler(new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, MinimapSession session, int availableWidth, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            Biome biome = mc.field_71441_e.func_175726_f(playerPos).func_177411_a(playerPos, mc.field_71441_e.func_72959_q());
            String biomeText = biome == null ? I18n.func_135052_a((String)"gui.xaero_unknown_biome", (Object[])new Object[0]) : biome.func_185359_l();
            compiler.addWords(biomeText);
        }
    }).setDestination(new Consumer<InfoDisplay<?>>(){

        @Override
        public void accept(InfoDisplay<?> infoDisplay) {
            ALL.add(infoDisplay);
        }
    }).build();
    public static final InfoDisplay<Boolean> WEATHER = InfoDisplay.Builder.begin().setId("weather").setName((ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_weather", new Object[0])).setDefaultState(false).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler(new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, MinimapSession session, int availableWidth, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            if (Minecraft.func_71410_x().field_71441_e.func_72911_I()) {
                compiler.addLine((ITextComponent)new TextComponentTranslation("gui.xaero_weather_thundering", new Object[0]));
            } else if (Minecraft.func_71410_x().field_71441_e.func_72896_J()) {
                compiler.addLine((ITextComponent)new TextComponentTranslation("gui.xaero_weather_raining", new Object[0]));
            }
        }
    }).setDestination(new Consumer<InfoDisplay<?>>(){

        @Override
        public void accept(InfoDisplay<?> infoDisplay) {
            ALL.add(infoDisplay);
        }
    }).build();
    public static final InfoDisplay<Integer> LIGHT_LEVEL = InfoDisplay.Builder.begin().setId("light_level").setName((ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_light_level", new Object[0])).setDefaultState(0).setCodec(InfoDisplayCommonStateCodecs.INTEGER).setWidgetFactory(new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4}), Lists.newArrayList((Object[])new ITextComponent[]{new TextComponentTranslation("gui.xaero_off", new Object[0]), new TextComponentTranslation("gui.xaero_light_block", new Object[0]), new TextComponentTranslation("gui.xaero_light_sky", new Object[0]), new TextComponentTranslation("gui.xaero_light_all", new Object[0]), new TextComponentTranslation("gui.xaero_light_both2", new Object[0])}))).setCompiler(new InfoDisplayOnCompile<Integer>(){

        @Override
        public void onCompile(InfoDisplay<Integer> displayInfo, InfoDisplayCompiler compiler, MinimapSession session, int availableWidth, BlockPos playerPos) {
            int skyLight;
            int blockLight;
            int showLightLevel = displayInfo.getState();
            if (showLightLevel == 0) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            int n = blockLight = playerPos.func_177956_o() >= 0 && playerPos.func_177956_o() < 256 ? mc.field_71441_e.func_175642_b(EnumSkyBlock.BLOCK, playerPos) : 0;
            int n2 = playerPos.func_177956_o() >= 256 ? 15 : (skyLight = playerPos.func_177956_o() < 0 ? 0 : mc.field_71441_e.func_175642_b(EnumSkyBlock.SKY, playerPos));
            if (showLightLevel == 1) {
                compiler.addLine((ITextComponent)new TextComponentTranslation("gui.xaero_block_light_value", new Object[]{blockLight}));
            } else if (showLightLevel == 2) {
                compiler.addLine((ITextComponent)new TextComponentTranslation("gui.xaero_sky_light_value", new Object[]{skyLight}));
            } else if (showLightLevel == 3) {
                compiler.addLine((ITextComponent)new TextComponentTranslation("gui.xaero_all_light_value", new Object[]{Math.max(blockLight, skyLight)}));
            } else {
                compiler.addLine((ITextComponent)new TextComponentTranslation("gui.xaero_both_light_value", new Object[]{blockLight, skyLight}));
            }
        }
    }).setDestination(new Consumer<InfoDisplay<?>>(){

        @Override
        public void accept(InfoDisplay<?> infoDisplay) {
            ALL.add(infoDisplay);
        }
    }).build();
    public static final InfoDisplay<Integer> TIME = InfoDisplay.Builder.begin().setId("time").setName((ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_time", new Object[0])).setDefaultState(0).setCodec(InfoDisplayCommonStateCodecs.INTEGER).setWidgetFactory(new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4}), Lists.newArrayList((Object[])new ITextComponent[]{new TextComponentTranslation("gui.xaero_off", new Object[0]), new TextComponentTranslation("%s+%s", new Object[]{new TextComponentTranslation("gui.xaero_day", new Object[0]), new TextComponentTranslation("gui.xaero_24h", new Object[0])}), new TextComponentTranslation("%s+%s", new Object[]{new TextComponentTranslation("gui.xaero_day", new Object[0]), new TextComponentTranslation("gui.xaero_12h", new Object[0])}), new TextComponentTranslation("gui.xaero_24h", new Object[0]), new TextComponentTranslation("gui.xaero_12h", new Object[0])}))).setCompiler(new InfoDisplayOnCompile<Integer>(){

        @Override
        public void onCompile(InfoDisplay<Integer> displayInfo, InfoDisplayCompiler compiler, MinimapSession session, int availableWidth, BlockPos playerPos) {
            int showTime = displayInfo.getState();
            if (showTime <= 0) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            long totalTime = 6000L + mc.field_71441_e.func_72820_D();
            int dayNumber = (int)(totalTime / 24000L) + 1;
            int dayTimeSinceMidnight = (int)(totalTime % 24000L);
            int timeHours = dayTimeSinceMidnight / 1000;
            int minutes = (int)((double)(dayTimeSinceMidnight % 1000) / 1000.0 * 60.0);
            if ((showTime - 1) % 2 == 0) {
                if (showTime < 3) {
                    compiler.addWords(I18n.func_135052_a((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d", dayNumber, timeHours, minutes));
                } else {
                    compiler.addWords(String.format("%02d:%02d", timeHours, minutes));
                }
            } else {
                String half = "AM";
                if (timeHours >= 12) {
                    timeHours -= 12;
                    half = "PM";
                }
                if (timeHours == 0) {
                    timeHours = 12;
                }
                if (showTime < 3) {
                    compiler.addWords(I18n.func_135052_a((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d %s", dayNumber, timeHours, minutes, half));
                } else {
                    compiler.addWords(String.format("%02d:%02d %s", timeHours, minutes, half));
                }
            }
        }
    }).setDestination(new Consumer<InfoDisplay<?>>(){

        @Override
        public void accept(InfoDisplay<?> infoDisplay) {
            ALL.add(infoDisplay);
        }
    }).build();
    private static final Calendar CALENDAR = Calendar.getInstance();
    public static final InfoDisplay<Integer> REAL_TIME = InfoDisplay.Builder.begin().setId("real_time").setName((ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_real_time", new Object[0])).setDefaultState(0).setCodec(InfoDisplayCommonStateCodecs.INTEGER).setWidgetFactory(new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2}), Lists.newArrayList((Object[])new ITextComponent[]{new TextComponentTranslation("gui.xaero_off", new Object[0]), new TextComponentTranslation("gui.xaero_24h", new Object[0]), new TextComponentTranslation("gui.xaero_12h", new Object[0])}))).setCompiler(new InfoDisplayOnCompile<Integer>(){

        @Override
        public void onCompile(InfoDisplay<Integer> displayInfo, InfoDisplayCompiler compiler, MinimapSession session, int availableWidth, BlockPos playerPos) {
            int showTime = displayInfo.getState();
            if (showTime <= 0) {
                return;
            }
            CALENDAR.setTimeInMillis(System.currentTimeMillis());
            int timeHours = CALENDAR.get(11);
            int minutes = CALENDAR.get(12);
            if (showTime == 1) {
                compiler.addWords(String.format("%02d:%02d IRL", timeHours, minutes));
            } else {
                String half = "AM";
                if (timeHours >= 12) {
                    timeHours -= 12;
                    half = "PM";
                }
                if (timeHours == 0) {
                    timeHours = 12;
                }
                compiler.addWords(String.format("%02d:%02d %s IRL", timeHours, minutes, half));
            }
        }
    }).setDestination(new Consumer<InfoDisplay<?>>(){

        @Override
        public void accept(InfoDisplay<?> infoDisplay) {
            ALL.add(infoDisplay);
        }
    }).build();
    public static final InfoDisplay<Boolean> HIGHLIGHTS = InfoDisplay.Builder.begin().setId("highlights").setName((ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_highlights", new Object[0])).setDefaultState(true).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.ALWAYS_ON).setCompiler(new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, MinimapSession session, int availableWidth, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            if (session.getProcessor().getMinimapWriter().getDimensionHighlightHandler() != null) {
                session.getProcessor().getMinimapWriter().getDimensionHighlightHandler().addBlockHighlightTooltips(compiler, playerPos.func_177958_n(), playerPos.func_177952_p(), availableWidth, true);
            }
        }
    }).setDestination(new Consumer<InfoDisplay<?>>(){

        @Override
        public void accept(InfoDisplay<?> infoDisplay) {
            ALL.add(infoDisplay);
        }
    }).build();
    public static final InfoDisplay<Boolean> LIGHT_OVERLAY_INDICATOR = InfoDisplay.Builder.begin().setId("light_overlay_indicator").setName((ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_light_overlay_indicator", new Object[0])).setDefaultState(true).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.ALWAYS_ON).setCompiler(new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, MinimapSession session, int availableWidth, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            if (session.getModMain().getSettings().lightOverlayType > 0) {
                compiler.addWords(I18n.func_135052_a((String)"gui.xaero_light_overlay_status", (Object[])new Object[0]));
            }
        }
    }).setDestination(new Consumer<InfoDisplay<?>>(){

        @Override
        public void accept(InfoDisplay<?> infoDisplay) {
            ALL.add(infoDisplay);
        }
    }).build();
    public static final InfoDisplay<Boolean> MANUAL_CAVE_MODE_INDICATOR = InfoDisplay.Builder.begin().setId("manual_cave_mode_indicator").setName((ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_manual_cave_mode_indicator", new Object[0])).setDefaultState(true).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.ALWAYS_ON).setCompiler(new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, MinimapSession session, int availableWidth, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            if (session.getProcessor().isManualCaveMode()) {
                compiler.addWords(I18n.func_135052_a((String)"gui.xaero_manual_cave_mode", (Object[])new Object[0]));
            }
        }
    }).setDestination(new Consumer<InfoDisplay<?>>(){

        @Override
        public void accept(InfoDisplay<?> infoDisplay) {
            ALL.add(infoDisplay);
        }
    }).build();
    public static final InfoDisplay<Boolean> CUSTOM_SUB_WORLD = InfoDisplay.Builder.begin().setId("custom_sub_world").setName((ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_custom_sub_world", new Object[0])).setDefaultState(true).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.ALWAYS_ON).setCompiler(new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, MinimapSession hudSession, int availableWidth, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
            MinimapWorldManager minimapWorldManager = session.getWorldManager();
            MinimapWorld currentWorld = minimapWorldManager.getCurrentWorld();
            if (currentWorld != null && minimapWorldManager.getAutoWorld() != currentWorld) {
                compiler.addWords(I18n.func_135052_a((String)"gui.xaero_using_custom_subworld", (Object[])new Object[]{currentWorld.getContainer().getSubName()}));
            }
        }
    }).setDestination(new Consumer<InfoDisplay<?>>(){

        @Override
        public void accept(InfoDisplay<?> infoDisplay) {
            ALL.add(infoDisplay);
        }
    }).build();

    public static void forEach(Consumer<InfoDisplay<?>> action) {
        ALL.forEach(action);
    }
}

