/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.element.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import xaero.common.misc.Misc;
import xaero.hud.entity.EntityUtils;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;

public class MinimapElementRenderInfo {
    public final MinimapElementRenderLocation location;
    public final Entity renderEntity;
    public final Vec3d renderEntityPos;
    public final EntityPlayer player;
    public final Vec3d renderPos;
    public final boolean cave;
    public final float partialTicks;
    public final Framebuffer framebuffer;
    public final ScaledResolution scaledResolution;
    public final double renderEntityDimensionScale;
    public final int renderEntityDimension;
    public final double backgroundCoordinateScale;
    public final int mapDimension;

    public MinimapElementRenderInfo(MinimapElementRenderLocation location, Entity renderEntity, EntityPlayer player, Vec3d renderPos, boolean cave, float partialTicks, Framebuffer framebuffer, ScaledResolution scaledResolution, double backgroundCoordinateScale, int mapDimension) {
        this.location = location;
        this.renderEntity = renderEntity;
        this.renderEntityPos = EntityUtils.getEntityPos(renderEntity, partialTicks);
        this.player = player;
        this.renderPos = renderPos;
        this.cave = cave;
        this.partialTicks = partialTicks;
        this.framebuffer = framebuffer;
        this.scaledResolution = scaledResolution;
        this.renderEntityDimensionScale = Misc.getDimensionTypeScale((World)Minecraft.func_71410_x().field_71441_e);
        this.renderEntityDimension = Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension();
        this.backgroundCoordinateScale = backgroundCoordinateScale;
        this.mapDimension = mapDimension;
    }
}

