/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.mods;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.registry.RegistryNamespacedDefaultedByKey;
import net.minecraft.world.World;
import xaero.common.misc.Misc;
import xaero.hud.minimap.MinimapLogs;

public class SupportFramedBlocks {
    private Class<?> framedTileBlockClass;
    private Method framedTileEntityCamoStateMethod;
    private Method framedTileEntityCamoMethod;
    private Method camoContainerStateMethod;
    private Method camoContainerContentMethod;
    private Method camoContentStateMethod;
    private boolean usable;
    private Set<Block> framedBlocks;

    public SupportFramedBlocks() {
        try {
            this.framedTileBlockClass = Class.forName("xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity");
        }
        catch (ClassNotFoundException cnfe) {
            try {
                this.framedTileBlockClass = Class.forName("xfacthd.framedblocks.common.tileentity.FramedTileEntity");
            }
            catch (ClassNotFoundException cnfe2) {
                try {
                    this.framedTileBlockClass = Class.forName("xfacthd.framedblocks.api.block.FramedBlockEntity");
                }
                catch (ClassNotFoundException cnfe3) {
                    MinimapLogs.LOGGER.info("Failed to init Framed Blocks support!", (Throwable)cnfe3);
                    return;
                }
            }
        }
        try {
            this.framedTileEntityCamoStateMethod = this.framedTileBlockClass.getDeclaredMethod("getCamoState", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e1) {
            try {
                Class<?> camoContainerClass;
                try {
                    camoContainerClass = Class.forName("xfacthd.framedblocks.api.data.CamoContainer");
                }
                catch (ClassNotFoundException cnfe) {
                    camoContainerClass = Class.forName("xfacthd.framedblocks.api.camo.CamoContainer");
                }
                this.framedTileEntityCamoMethod = this.framedTileBlockClass.getDeclaredMethod("getCamo", new Class[0]);
                try {
                    this.camoContainerStateMethod = camoContainerClass.getDeclaredMethod("getState", new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    this.camoContainerContentMethod = camoContainerClass.getDeclaredMethod("getContent", new Class[0]);
                    Class<?> camoContentClass = Class.forName("xfacthd.framedblocks.api.camo.CamoContent");
                    this.camoContentStateMethod = camoContentClass.getDeclaredMethod("getAppearanceState", new Class[0]);
                }
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e2) {
                MinimapLogs.LOGGER.info("Failed to init Framed Blocks support!", (Throwable)e1);
                MinimapLogs.LOGGER.info("Failed to init Framed Blocks support!", (Throwable)e2);
            }
        }
        this.usable = this.framedTileBlockClass != null && (this.framedTileEntityCamoStateMethod != null || this.framedTileEntityCamoMethod != null && (this.camoContainerStateMethod != null || this.camoContainerContentMethod != null && this.camoContentStateMethod != null));
    }

    public void onWorldChange() {
        this.framedBlocks = null;
    }

    private void findFramedBlocks(World world, IRegistry<ResourceLocation, Block> registry) {
        if (this.framedBlocks == null) {
            this.framedBlocks = new HashSet<Block>();
            if (registry == null) {
                registry = Block.field_149771_c;
            }
            RegistryNamespacedDefaultedByKey forwardedRegistry = registry;
            registry.func_148742_b().forEach(new Consumer<ResourceLocation>((IRegistry)forwardedRegistry){
                final /* synthetic */ IRegistry val$forwardedRegistry;
                {
                    this.val$forwardedRegistry = iRegistry;
                }

                @Override
                public void accept(ResourceLocation key) {
                    if (key.func_110624_b().equals("framedblocks") && key.func_110623_a().startsWith("framed_")) {
                        SupportFramedBlocks.this.framedBlocks.add(this.val$forwardedRegistry.func_82594_a((Object)key));
                    }
                }
            });
        }
    }

    public boolean isFrameBlock(World world, IRegistry<ResourceLocation, Block> registry, IBlockState state) {
        if (!this.usable) {
            return false;
        }
        this.findFramedBlocks(world, registry);
        return this.framedBlocks.contains(state.func_177230_c());
    }

    public IBlockState unpackFramedBlock(World world, IRegistry<ResourceLocation, Block> registry, IBlockState original, TileEntity tileEntity) {
        if (!this.usable) {
            return original;
        }
        if (this.framedTileBlockClass.isAssignableFrom(tileEntity.getClass())) {
            if (this.framedTileEntityCamoStateMethod != null) {
                return (IBlockState)Misc.getReflectMethodValue(tileEntity, this.framedTileEntityCamoStateMethod, new Object[0]);
            }
            Object camoContainer = Misc.getReflectMethodValue(tileEntity, this.framedTileEntityCamoMethod, new Object[0]);
            if (this.camoContainerStateMethod != null) {
                return (IBlockState)Misc.getReflectMethodValue(camoContainer, this.camoContainerStateMethod, new Object[0]);
            }
            Object camoContent = Misc.getReflectMethodValue(camoContainer, this.camoContainerContentMethod, new Object[0]);
            if (camoContent == null) {
                return original;
            }
            IBlockState state = (IBlockState)Misc.getReflectMethodValue(camoContent, this.camoContentStateMethod, new Object[0]);
            if (state == null) {
                return original;
            }
            return state;
        }
        return original;
    }
}

