/*
 * Decompiled with CFR 0.152.
 */
package me.maxish0t.wac.server.packets.server;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import me.maxish0t.wac.api.DiscordUtils;
import me.maxish0t.wac.common.configs.ServerConfig;
import me.maxish0t.wac.common.handlers.ServerEvents;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class AntiCheatPacket
implements IMessage {
    private int messageID;
    public static String data;
    private static ArrayList<String> clientList;
    public static boolean hasSentInfo;

    public AntiCheatPacket() {
    }

    public AntiCheatPacket(int number) {
        this.messageID = number;
        data = "NONE";
    }

    public AntiCheatPacket(int number, String modList) {
        this.messageID = number;
        data = modList;
    }

    public void fromBytes(ByteBuf buf) {
        this.messageID = buf.readInt();
        data = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.messageID);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)data);
    }

    private static boolean userHasExtraBadItems(ArrayList<String> badItems, boolean checkMods) {
        if (checkMods) {
            ArrayList<String> serverSideMods = ServerConfig.getWhitelistedMods();
            ArrayList<String> listOne = new ArrayList<String>(serverSideMods);
            ArrayList<String> listTwo = new ArrayList<String>(badItems);
            listTwo.removeAll(listOne);
            if (listTwo.isEmpty()) {
                return false;
            }
        } else {
            ArrayList<String> listTwo = new ArrayList<String>(badItems);
            if (listTwo.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    private static Collection<String> getExtraBadItems(ArrayList<String> clientMods) {
        ArrayList<String> serverSideMods = ServerConfig.getWhitelistedMods();
        ArrayList<String> listOne = new ArrayList<String>(serverSideMods);
        ArrayList<String> listTwo = new ArrayList<String>(clientMods);
        listTwo.removeAll(listOne);
        return listTwo;
    }

    private static boolean canUserConnectWithExtraBadItems(String username) {
        ArrayList<String> playerModWhitelist = ServerConfig.getModWhitelistedPlayers();
        return playerModWhitelist.contains(username);
    }

    static {
        hasSentInfo = false;
    }

    public static class Handler
    implements IMessageHandler<AntiCheatPacket, IMessage> {
        public IMessage onMessage(AntiCheatPacket message, MessageContext ctx) {
            EntityPlayerMP player;
            if (ctx != null && (player = ctx.getServerHandler().field_147369_b) != null) {
                String playerName = player.func_70005_c_();
                if (ServerConfig.useAntiCheat && message.messageID == 0 && !data.equals("NONE")) {
                    clientList = new ArrayList<String>(Arrays.asList(data.split(",")));
                    Collection extraMods = AntiCheatPacket.getExtraBadItems(clientList);
                    if (AntiCheatPacket.userHasExtraBadItems(clientList, true) && !AntiCheatPacket.canUserConnectWithExtraBadItems(playerName)) {
                        ArrayList<String> updatedExtraMods = new ArrayList<String>();
                        for (String value : extraMods) {
                            String fixed = value.substring(value.indexOf("-") + 1);
                            fixed = fixed.trim();
                            updatedExtraMods.add(fixed);
                        }
                        if (!hasSentInfo) {
                            ServerEvents.playerExtraMods.put(player.func_70005_c_(), ((Object)updatedExtraMods).toString());
                            ServerConfig.addToCheaterList(playerName + " kicked due to extra mods: " + extraMods);
                            if (ServerConfig.ENABLE_DISCORD_WEBHOOK == Boolean.TRUE) {
                                DiscordUtils.sendWebhook(ServerConfig.DISCORD_WEBHOOK_LINK, playerName, "Extra Mods: " + updatedExtraMods);
                            }
                            hasSentInfo = true;
                        }
                    }
                }
            }
            return null;
        }
    }
}

