/*
 * Decompiled with CFR 0.152.
 */
package me.maxish0t.wac.common.configs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import me.maxish0t.wac.WatchdogAC;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;

public class ServerConfig {
    private static final File configDirectory = new File(Loader.instance().getConfigDir(), "/WatchDogAC");
    private static final File configFile = new File(configDirectory, "watchdog-ac-common.cfg");
    private static File playerCheatingFile = new File(configDirectory, "player_cheating_log.txt");
    private static File allLoadedMods = new File(configDirectory, "generated-mods-list.txt");
    private static final Properties serverProps = new Properties();
    public static boolean useAntiCheat;
    public static boolean ENABLE_DISCORD_WEBHOOK;
    public static String DISCORD_LINK;
    public static String DISCORD_WEBHOOK_LINK;
    public static String KICK_MESSAGE;
    public static String encodedWhitelistedMods;
    private static ArrayList<String> whitelistedMods;
    private static String encodedModWhitelistPlayers;
    private static ArrayList<String> modWhitelistedPlayers;

    public ServerConfig() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side.isClient()) {
            return;
        }
        ServerConfig.reloadConfig();
    }

    public static void reloadConfig() {
        ServerConfig.loadConfig();
        ServerConfig.loadExtraFiles();
        useAntiCheat = (Boolean)ServerConfig.loadProp(serverProps, useAntiCheat, Boolean.TRUE, "useAntiCheat");
        encodedWhitelistedMods = (String)ServerConfig.loadProp(serverProps, encodedWhitelistedMods, "", "whitelistModsMD5");
        String[] decodedModWhitelist = ServerConfig.decodeData(encodedWhitelistedMods, ",");
        ServerConfig.loadArrayData(decodedModWhitelist, whitelistedMods);
        encodedModWhitelistPlayers = (String)ServerConfig.loadProp(serverProps, encodedWhitelistedMods, "MaxIsH0t, TestUser", "modWhitelistPlayers");
        String[] decodedModWhitelistPlayers = ServerConfig.decodeData(encodedModWhitelistPlayers, ",");
        ServerConfig.loadArrayData(decodedModWhitelistPlayers, modWhitelistedPlayers);
        ServerConfig.saveConfig();
    }

    private static void loadExtraFiles() {
        if (playerCheatingFile.exists()) {
            WatchdogAC.logger.info("Successfully loaded player cheating file");
        } else {
            try {
                WatchdogAC.logger.info("Player cheating file not found! Creating a new one...");
                playerCheatingFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (allLoadedMods.exists()) {
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(allLoadedMods);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            writer.print("");
            writer.close();
        } else {
            try {
                allLoadedMods.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addToModList(String modName, String modID) {
        if (allLoadedMods != null) {
            try {
                FileWriter fw = new FileWriter(allLoadedMods, true);
                BufferedWriter bw = new BufferedWriter(fw);
                PrintWriter pw = new PrintWriter(bw);
                pw.println(modName + " | " + modID);
                pw.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addEntireListToModFile(String allMods) {
        if (allLoadedMods != null) {
            try {
                FileWriter fw = new FileWriter(allLoadedMods, true);
                BufferedWriter bw = new BufferedWriter(fw);
                PrintWriter pw = new PrintWriter(bw);
                pw.println("COPY THIS ENTIRE LIST AND PASTE IT IN Whitelisted Mods OPTION IN THE watchdog-ac-common Config :");
                pw.println(allMods);
                pw.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadConfig() {
        ServerConfig.loadConfig(configDirectory, configFile, serverProps);
    }

    private static void saveConfig() {
        ServerConfig.saveConfig(configDirectory, configFile, serverProps, "~WatchDog AntiCheat Anti-Cheat Server Setup~");
    }

    public static void addToCheaterList(String playerData) {
        if (playerCheatingFile != null) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = new Date();
                String timeNow = formatter.format(date);
                FileWriter fw = new FileWriter(playerCheatingFile, true);
                BufferedWriter bw = new BufferedWriter(fw);
                PrintWriter pw = new PrintWriter(bw);
                pw.println(timeNow + " | " + playerData);
                pw.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static ArrayList<String> getModWhitelistedPlayers() {
        return modWhitelistedPlayers;
    }

    public static ArrayList<String> getWhitelistedMods() {
        return whitelistedMods;
    }

    private static void loadArrayData(String[] data, ArrayList<String> arrayList) {
        arrayList.clear();
        if (data != null) {
            for (String d : data) {
                arrayList.add(d);
            }
        }
    }

    public static String[] decodeData(String loc, String splitby) {
        if (loc.equals("null")) {
            return null;
        }
        if (splitby == null) {
            String[] data = loc.split("\\|");
            return data;
        }
        String[] data = loc.split("\\" + splitby);
        if (!loc.contains(splitby)) {
            data = new String[]{loc};
        }
        return data;
    }

    public static Object loadProp(Properties p, Object o, Object def, String pname) {
        if (p.containsKey(pname)) {
            o = ServerConfig.parseObject(o, p.getProperty(pname));
            WatchdogAC.logger.info("Loaded config property '" + pname + "' = " + o);
            return o;
        }
        p.setProperty(pname, ServerConfig.toStringObject(def));
        WatchdogAC.logger.info("Setup config property '" + pname + "'(" + def + ")");
        return def;
    }

    private static String toStringObject(Object o) {
        if (o instanceof Boolean) {
            return ((Boolean)o).toString();
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).toString();
        }
        if (o instanceof Float) {
            return o.toString();
        }
        return "";
    }

    private static Object parseObject(Object o, String property) {
        if (o instanceof Boolean) {
            return Boolean.parseBoolean(property);
        }
        if (o instanceof String) {
            return property;
        }
        if (o instanceof Integer) {
            return Integer.parseInt(property);
        }
        if (o instanceof Float) {
            return Float.valueOf(Float.parseFloat(property));
        }
        return "";
    }

    public static void loadConfig(File dir, File file, Properties prop) {
        try {
            dir.mkdir();
            if (!file.exists() && !file.createNewFile()) {
                return;
            }
            if (file.canRead()) {
                FileInputStream fileinputstream = new FileInputStream(file);
                prop.load(fileinputstream);
                fileinputstream.close();
            }
        }
        catch (IOException ex) {
            WatchdogAC.logger.info("Could not load WatchDog AntiCheat - Config file.");
        }
    }

    public static void saveConfig(File dir, File file, Properties prop, String comment) {
        try {
            dir.mkdir();
            if (!file.exists() && !file.createNewFile()) {
                return;
            }
            if (file.canWrite()) {
                FileOutputStream fileoutputstream = new FileOutputStream(file);
                prop.store(fileoutputstream, comment);
                fileoutputstream.close();
            }
        }
        catch (IOException ex) {
            WatchdogAC.logger.info("Could not save WatchDog AntiCheat - Config file.");
        }
    }

    static {
        DISCORD_LINK = "...";
        KICK_MESSAGE = "Hello";
        encodedWhitelistedMods = "null";
        whitelistedMods = new ArrayList();
        encodedModWhitelistPlayers = "null";
        modWhitelistedPlayers = new ArrayList();
    }
}

