/*
 * Decompiled with CFR 0.152.
 */
package com.itsradiix.discordwebhook;

import com.itsradiix.discordwebhook.embed.Embed;
import com.itsradiix.discordwebhook.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class DiscordWebHook {
    private final String username;
    private final String avatar_url;
    private final String content;
    private final List<Embed> embeds;

    private DiscordWebHook(String username, String avatar_url, String content, List<Embed> embeds) {
        this.username = username;
        this.avatar_url = avatar_url;
        this.content = content;
        this.embeds = embeds;
    }

    public String getUsername() {
        return this.username;
    }

    public String getAvatar_url() {
        return this.avatar_url;
    }

    public String getContent() {
        return this.content;
    }

    public List<Embed> getEmbeds() {
        return this.embeds;
    }

    public static void sendMessage(String URL, DiscordWebHook message) {
        Utils.postToAPI(URL, Utils.serializeObject(message));
    }

    public static class Builder {
        private String username;
        private String avatar_url;
        private String content;
        private List<Embed> embeds;

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder avatar_url(String avatar_url) {
            this.avatar_url = avatar_url;
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder embed(Embed embed) {
            if (this.embeds == null) {
                this.embeds = new ArrayList<Embed>();
            }
            this.embeds.add(embed);
            return this;
        }

        public DiscordWebHook build() {
            return new DiscordWebHook(this.username, this.avatar_url, this.content, this.embeds);
        }
    }
}

