/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blocks;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.tileentity.TileEntityTravelersBackpack;
import com.tiviacz.travelersbackpack.util.Bounds;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSleepingBag
extends BlockHorizontal {
    public static final PropertyBool OCCUPIED = PropertyBool.func_177716_a((String)"occupied");
    private static final AxisAlignedBB BOUNDING_BOX = new Bounds(0, 0, 0, 16, 2, 16).toAABB();

    public BlockSleepingBag(String name, Material materialIn) {
        super(materialIn);
        this.setRegistryName(name);
        this.func_149663_c(name);
        this.func_149647_a(TravelersBackpack.TRAVELERSBACKPACKTAB);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149711_c(1.0f);
        this.func_149752_b(3.0f);
        this.setHarvestLevel("hand", 0);
        ModBlocks.BLOCKS.add((Block)this);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.25f);
    }

    public void func_176216_a(World worldIn, Entity entityIn) {
        if (entityIn.func_70093_af()) {
            super.func_176216_a(worldIn, entityIn);
        } else if (entityIn.field_70181_x < 0.0) {
            entityIn.field_70181_x = -entityIn.field_70181_x * 0.8;
            if (!(entityIn instanceof EntityLivingBase)) {
                entityIn.field_70181_x *= 0.8;
            }
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        BlockPos mayTilePos;
        EnumFacing blockFacing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        if (state.func_177230_c() == ModBlocks.SLEEPING_BAG_BOTTOM) {
            BlockPos mayTilePos2;
            if (!world.field_72995_K && world.func_175625_s(mayTilePos2 = pos.func_177972_a(blockFacing.func_176734_d())) instanceof TileEntityTravelersBackpack) {
                TileEntityTravelersBackpack tile = (TileEntityTravelersBackpack)world.func_175625_s(mayTilePos2);
                tile.setSleepingBagDeployed(false);
                tile.func_70296_d();
            }
        } else if (state.func_177230_c() == ModBlocks.SLEEPING_BAG_TOP && !world.field_72995_K && world.func_175625_s(mayTilePos = pos.func_177967_a(blockFacing.func_176734_d(), 2)) instanceof TileEntityTravelersBackpack) {
            TileEntityTravelersBackpack tile = (TileEntityTravelersBackpack)world.func_175625_s(mayTilePos);
            tile.setSleepingBagDeployed(false);
            tile.func_70296_d();
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (this == ModBlocks.SLEEPING_BAG_BOTTOM && (state = worldIn.func_180495_p(pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)))).func_177230_c() != ModBlocks.SLEEPING_BAG_TOP) {
            return true;
        }
        if (worldIn.field_73011_w.func_76567_e() && worldIn.func_180494_b(pos) != Biomes.field_76778_j) {
            EntityPlayer.SleepResult sleepResult;
            if (((Boolean)state.func_177229_b((IProperty)OCCUPIED)).booleanValue()) {
                EntityPlayer entityplayer = this.getPlayerInBed(worldIn, pos);
                if (entityplayer != null) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.occupied", new Object[0]), true);
                    return true;
                }
                state = state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.FALSE);
                worldIn.func_180501_a(pos, state, 3);
            }
            if ((sleepResult = playerIn.func_180469_a(pos)) == EntityPlayer.SleepResult.OK) {
                state = state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.TRUE);
                worldIn.func_180501_a(pos, state, 3);
                return true;
            }
            if (sleepResult == EntityPlayer.SleepResult.NOT_POSSIBLE_NOW) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.noSleep", new Object[0]), true);
            } else if (sleepResult == EntityPlayer.SleepResult.NOT_SAFE) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.notSafe", new Object[0]), true);
            } else if (sleepResult == EntityPlayer.SleepResult.TOO_FAR_AWAY) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.tooFarAway", new Object[0]), true);
            }
            return true;
        }
        worldIn.func_175698_g(pos);
        EnumFacing facing1 = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        pos = pos.func_177972_a(this == ModBlocks.SLEEPING_BAG_TOP ? facing1.func_176734_d() : facing1);
        if (worldIn.func_180495_p(pos).func_177230_c() == (this == ModBlocks.SLEEPING_BAG_TOP ? ModBlocks.SLEEPING_BAG_BOTTOM : ModBlocks.SLEEPING_BAG_TOP)) {
            worldIn.func_175698_g(pos);
        }
        worldIn.func_72885_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, true);
        return true;
    }

    @Nullable
    private EntityPlayer getPlayerInBed(World worldIn, BlockPos pos) {
        for (EntityPlayer entityplayer : worldIn.field_73010_i) {
            if (!entityplayer.func_70608_bn() || !entityplayer.field_71081_bT.equals((Object)pos)) continue;
            return entityplayer;
        }
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(meta > 3));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)OCCUPIED)).booleanValue()) {
            meta += 4;
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, OCCUPIED});
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        if (this == ModBlocks.SLEEPING_BAG_TOP) {
            if (worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177230_c() == ModBlocks.SLEEPING_BAG_BOTTOM) {
                worldIn.func_175655_b(pos.func_177972_a(facing.func_176734_d()), false);
            }
        } else if (this == ModBlocks.SLEEPING_BAG_BOTTOM && worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c() == ModBlocks.SLEEPING_BAG_TOP) {
            worldIn.func_175655_b(pos.func_177972_a(facing), false);
        }
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity player) {
        return true;
    }

    public void setBedOccupied(IBlockAccess blockAccess, BlockPos pos, EntityPlayer player, boolean occupied) {
        if (blockAccess instanceof World) {
            World world = (World)blockAccess;
            TileEntity tileEntity = world.func_175625_s(pos);
            IBlockState state = world.func_180495_p(pos);
            state = state.func_177230_c().func_176221_a(state, (IBlockAccess)world, pos);
            state = state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(occupied));
            world.func_180501_a(pos, state, 4);
            if (tileEntity != null) {
                tileEntity.func_145829_t();
                world.func_175690_a(pos, tileEntity);
            }
        }
    }

    public EnumFacing getBedDirection(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (EnumFacing)this.func_176221_a(state, world, pos).func_177229_b((IProperty)field_185512_D);
    }

    public boolean isBedFoot(IBlockAccess world, BlockPos pos) {
        return this == ModBlocks.SLEEPING_BAG_BOTTOM;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(ModItems.SLEEPING_BAG);
    }

    public int func_149745_a(Random random) {
        return 0;
    }
}

