/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.fluid.util;

import com.google.common.primitives.Ints;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.ISpecializedFluidNeighborInfo;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.impl.SpecializedFluidNeighborInfo;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.BlockStateContainer;
import net.minecraftforge.fluids.BlockFluidFinite;

public interface IFluidUpdateHelper
extends ISpecializedFluidNeighborInfo {
    public static final int DEFAULT_COST = 1000;

    default public int calculateFlowCostI(int xi, int yi, int zi, int quantaPerBlock, int flowMeta, int flowCost, int recurseDepth, @Nonnull IntUnaryOperator downMeta, @Nonnull EnumFacing checkedSide) {
        int cost = 1000;
        for (int adjSide = 0; adjSide < 4; ++adjSide) {
            EnumFacing side = EnumFacing.field_176754_o[adjSide];
            if (side == checkedSide) continue;
            int xio = xi + side.func_82601_c();
            int zio = zi + side.func_82599_e();
            FluidState fluid = this.getFluidStateI(xio, yi, zio);
            int cappedLvl = Math.min(flowMeta + recurseDepth, quantaPerBlock - 1);
            if (FluidloggedUtils.isCompatibleFluid(fluid, this.getOrigin()) && fluid.isSource() || !this.canFlowIntoI(xi, yi, zi, cappedLvl, side, true, true)) continue;
            if (this.canFlowIntoI(xio, yi, zio, downMeta.applyAsInt(cappedLvl), this.getOrigin().getDownDensityFace(), true, true)) {
                return recurseDepth;
            }
            if (recurseDepth >= quantaPerBlock >> flowCost) continue;
            cost = Math.min(cost, this.calculateFlowCostI(xio, yi, zio, quantaPerBlock, flowMeta, flowCost, recurseDepth + flowCost, downMeta, side.func_176734_d()));
        }
        return cost;
    }

    @Nonnull
    default public int[] getOptimalFlowDirectionsI(int xi, int yi, int zi, int quantaPerBlock, int flowMeta, int flowCost, @Nonnull IntUnaryOperator downMeta) {
        int sideI;
        int[] adjFlowCost = new int[4];
        for (int sideI2 = 0; sideI2 < 4; ++sideI2) {
            int zio;
            adjFlowCost[sideI2] = 1000;
            EnumFacing side = EnumFacing.field_176754_o[sideI2];
            int xio = xi + side.func_82601_c();
            FluidState fluid = this.getFluidStateI(xio, yi, zio = zi + side.func_82599_e());
            if (FluidloggedUtils.isCompatibleFluid(fluid, this.getOrigin()) && fluid.isSource() || !this.canFlowIntoI(xi, yi, zi, flowMeta, side, true, true)) continue;
            adjFlowCost[sideI2] = this.canFlowIntoI(xio, yi, zio, downMeta.applyAsInt(flowMeta), this.getOrigin().getDownDensityFace(), true, true) ? 0 : (flowMeta < quantaPerBlock ? this.calculateFlowCostI(xio, yi, zio, quantaPerBlock, flowMeta, flowCost, flowCost, downMeta, side.func_176734_d()) : 1000);
        }
        int[] isOptimalFlowDirection = new int[4];
        int min = Ints.min((int[])adjFlowCost);
        for (sideI = 0; sideI < 4; ++sideI) {
            isOptimalFlowDirection[sideI] = adjFlowCost[sideI] == min ? flowMeta : -1;
        }
        if (!FluidloggedAPIConfig.nonSourceFluidlogging && FluidloggedUtils.canCreateSource(this.getOrigin().getState(), this.getCache().getWorld(), this.getPosIB(xi, yi, zi))) {
            block2: for (sideI = 0; sideI < 4; ++sideI) {
                if (min != 1000 && (isOptimalFlowDirection[sideI] != -1 || !this.canFluidFlowI(xi, yi, zi, EnumFacing.field_176754_o[sideI]))) continue;
                int adj = this.getOrigin().isSource() ? 1 : 0;
                EnumFacing side = EnumFacing.field_176754_o[sideI];
                int xio = xi + side.func_82601_c();
                int zio = zi + side.func_82599_e();
                if (!this.getBlockStateI(xio, yi + this.getOrigin().getDensityDir(), zio).func_185904_a().func_76220_a() && this.canFluidFlowI(xio, yi, zio, this.getOrigin().getDownDensityFace()) && !this.isSourceI(xio, yi + this.getOrigin().getDensityDir(), zio, this.getOrigin().getUpDensityFace()) || !FluidloggedUtils.isStateFluidloggable(this.getBlockStateI(xio, yi, zio), this.getCache(), this.getPosIB(xio, yi, zio), this.getOrigin().toSource())) continue;
                for (EnumFacing sideA : EnumFacing.field_176754_o) {
                    int zioA;
                    int xioA;
                    FluidState fluidState;
                    if (sideA == side.func_176734_d() || !this.canFluidFlowI(xio, yi, zio, sideA) || !(fluidState = this.getFluidStateI(xioA = xio + sideA.func_82601_c(), yi, zioA = zio + sideA.func_82599_e())).isSource() || !FluidloggedUtils.isCompatibleFluid(this.getOrigin(), fluidState) || !this.canFluidFlowI(xioA, yi, zioA, sideA.func_176734_d()) || ++adj != 2) continue;
                    isOptimalFlowDirection[sideI] = this.getOrigin().toSource().getLevel();
                    continue block2;
                }
            }
        }
        return isOptimalFlowDirection;
    }

    default public boolean isSourceI(int xi, int yi, int zi, @Nonnull EnumFacing side) {
        return this.isCompatibleFluidI(xi, yi, zi) && this.canFluidFlowI(xi, yi, zi, side) && this.getFluidStateI(xi, yi, zi).isSource();
    }

    default public boolean flowIntoI(int xi, int yi, int zi, int level, @Nonnull EnumFacing sideToCheck, boolean checkReplaceable, boolean allowMatching, int blockFlags) {
        boolean ret = false;
        if (level >= 0 && this.canFlowIntoI(xi, yi, zi, level, sideToCheck, checkReplaceable, allowMatching)) {
            int xio = xi + sideToCheck.func_176730_m().func_177958_n();
            int yio = yi + sideToCheck.func_176730_m().func_177956_o() * -this.getOrigin().getDensityDir();
            int zio = zi + sideToCheck.func_176730_m().func_177952_p();
            if (this.getOrigin().getBlock() instanceof BlockFluidFinite || !this.isCompatibleFluidI(xio, yio, zio)) {
                boolean vaporize = this.vaporizeI(xio, yio, zio, this.getOrigin().withLevel(level), sideToCheck.func_176734_d());
                Boolean prevFireTick = this.getDoFireTick();
                this.setDoFireTick(Boolean.FALSE);
                if (vaporize || this.isReplaceableI(xio, yio, zio, this.getOrigin().withLevel(level), sideToCheck.func_176734_d(), true, false)) {
                    if (!vaporize) {
                        IBlockState oldState = this.getBlockStateI(xio, yio, zio);
                        if (oldState.func_177230_c() != this.getOrigin().getBlock() && this.getOrigin().getMaterial() == Material.field_151587_i && !oldState.func_177230_c().isAir(oldState, (IBlockAccess)this.getCache(), this.getPosIB(xio, yio, zio))) {
                            FluidloggedUtils.playVaporizeEffects(this.getCache().getWorld(), (BlockPos)this.getCache().mutablePos, this.getOrigin().withLevel(level).createFluidStack());
                        } else if (oldState.func_185904_a().func_76229_l()) {
                            oldState.func_177230_c().func_176226_b(this.getCache().getWorld(), this.getPosIB(xio, yio, zio), oldState, 0);
                        }
                    }
                    ret = this.getCache().getWorld().func_180501_a(this.getPosIB(xio, yio, zio), this.getOrigin().withLevel(level).getState(), blockFlags);
                } else if (this.canFluidFlowI(xio, yio, zio, sideToCheck.func_176734_d()) && this.isFluidloggableI(xio, yio, zio, this.getOrigin().withLevel(level), sideToCheck.func_176734_d(), true, false)) {
                    ret = FluidloggedUtils.setFluidState(this.getCache().getWorld(), this.getPosIB(xio, yio, zio), this.getBlockStateI(xio, yio, zio), this.getOrigin().withLevel(level), false, blockFlags);
                }
                this.setDoFireTick(prevFireTick);
            }
        }
        return ret;
    }

    default public void setFluidI(int xi, int yi, int zi, @Nonnull FluidState fluidToPlace, boolean setToAir, int tickRate, int blockFlags) {
        if (this.getBlockStateI(xi, yi, zi).func_177230_c() == this.getOrigin().getBlock() || !setToAir && this.vaporizeI(xi, yi, zi, fluidToPlace, null)) {
            if (setToAir) {
                this.getCache().getWorld().func_175656_a(this.getPosIB(xi, yi, zi), BlockStateContainer.field_186020_a);
            } else {
                this.getCache().getWorld().func_180501_a(this.getPosIB(xi, yi, zi), fluidToPlace.getState(), blockFlags);
                if (tickRate > 0) {
                    this.getCache().getWorld().func_175684_a((BlockPos)this.getCache().mutablePos, this.getOrigin().getBlock(), tickRate);
                    this.getCache().getWorld().func_175685_c((BlockPos)this.getCache().mutablePos, this.getOrigin().getBlock(), false);
                }
            }
        } else if (setToAir) {
            FluidloggedUtils.setFluidState(this.getCache().getWorld(), this.getPosIB(xi, yi, zi), this.getBlockStateI(xi, yi, zi), FluidState.EMPTY, false);
        } else if (!this.isFluidloggableI(xi, yi, zi, fluidToPlace, null, false, false)) {
            FluidloggedUtils.setFluidState(this.getCache().getWorld(), this.getPosIB(xi, yi, zi), this.getBlockStateI(xi, yi, zi), FluidState.EMPTY, false);
        } else {
            FluidloggedUtils.setFluidState(this.getCache().getWorld(), this.getPosIB(xi, yi, zi), this.getBlockStateI(xi, yi, zi), fluidToPlace, false, blockFlags);
            if (tickRate > 0) {
                this.getCache().getWorld().func_175684_a((BlockPos)this.getCache().mutablePos, this.getOrigin().getBlock(), tickRate);
                this.getCache().getWorld().func_175685_c((BlockPos)this.getCache().mutablePos, this.getOrigin().getBlock(), false);
            }
        }
    }

    default public void resetDataAtI(int xi, int yi, int zi) {
    }

    default public boolean vaporizeI(int xi, int yi, int zi, @Nonnull FluidState fluidToPlace, @Nullable EnumFacing sideToCheck) {
        if (this.isVaporizableI(xi, yi, zi, fluidToPlace, sideToCheck)) {
            FluidloggedUtils.playVaporizeEffects(this.getCache().getWorld(), this.getPosIB(xi, yi, zi), fluidToPlace.createFluidStack());
            return true;
        }
        return false;
    }

    default public int calculateFlowCost(int x, int y, int z, int quantaPerBlock, int flowMeta, int flowCost, int recurseDepth, @Nonnull IntUnaryOperator downMeta, @Nonnull EnumFacing checkedSide) {
        return this.calculateFlowCostI(this.getXI(x), this.getYI(y), this.getZI(z), quantaPerBlock, flowMeta, flowCost, recurseDepth, downMeta, checkedSide);
    }

    @Nonnull
    default public int[] getOptimalFlowDirections(int x, int y, int z, int quantaPerBlock, int flowMeta, int flowCost, @Nonnull IntUnaryOperator downMeta) {
        return this.getOptimalFlowDirectionsI(this.getXI(x), this.getYI(y), this.getZI(z), quantaPerBlock, flowMeta, flowCost, downMeta);
    }

    default public boolean isSource(int x, int y, int z, @Nonnull EnumFacing side) {
        return this.isSourceI(this.getXI(x), this.getYI(y), this.getZI(z), side);
    }

    default public boolean flowInto(int x, int y, int z, int level, @Nonnull EnumFacing sideToCheck, boolean checkReplaceable, boolean allowMatching, int blockFlags) {
        return this.flowIntoI(this.getXI(x), this.getYI(y), this.getZI(z), level, sideToCheck, checkReplaceable, allowMatching, blockFlags);
    }

    default public void setFluid(int x, int y, int z, @Nonnull FluidState fluidToPlace, boolean setToAir, int tickRate) {
        this.setFluidI(this.getXI(x), this.getYI(y), this.getZI(z), fluidToPlace, setToAir, tickRate, 2);
    }

    default public void setFluid(int x, int y, int z, @Nonnull FluidState fluidToPlace, boolean setToAir, int tickRate, int blockFlags) {
        this.setFluidI(this.getXI(x), this.getYI(y), this.getZI(z), fluidToPlace, setToAir, tickRate, blockFlags);
    }

    default public void resetDataAt(int x, int y, int z) {
        this.resetDataAtI(this.getXI(x), this.getYI(y), this.getZI(z));
    }

    default public boolean vaporize(int x, int y, int z, @Nonnull FluidState fluidToPlace, @Nullable EnumFacing sideToCheck) {
        return this.vaporizeI(this.getXI(x), this.getYI(y), this.getZI(z), fluidToPlace, sideToCheck);
    }

    public static class Vanilla
    extends SpecializedFluidNeighborInfo.Vanilla
    implements IFluidUpdateHelper {
        public Vanilla(@Nonnull IBlockAccess accessIn, @Nonnull BlockPos originIn, @Nonnull FluidState originStateIn, int radius) {
            super(accessIn, originIn, originStateIn, radius);
        }
    }

    public static class Forge
    extends SpecializedFluidNeighborInfo.Forge
    implements IFluidUpdateHelper {
        public Forge(@Nonnull IBlockAccess accessIn, @Nonnull BlockPos originIn, @Nonnull FluidState originStateIn, int radius) {
            super(accessIn, originIn, originStateIn, radius);
        }
    }
}

