/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.fluid.handler;

import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.asm.iface.IConditionalFluid;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.IFluidUpdateHelper;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.ISpecializedFluidNeighborInfo;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.impl.SpecializedFluidNeighborInfo;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.BlockFluidBase;

public final class FluidFlowHandler {
    public static double getFlowAngle(@Nonnull Vec3d flowVec) {
        return flowVec.field_72450_a == 0.0 && flowVec.field_72449_c == 0.0 ? -1000.0 : MathHelper.func_181159_b((double)flowVec.field_72449_c, (double)flowVec.field_72450_a) - 1.5707963267948966;
    }

    public static double getFlowAngle(@Nonnull ISpecializedFluidNeighborInfo info) {
        return FluidFlowHandler.getFlowAngle(FluidFlowHandler.getFlowVec(info));
    }

    @Nonnull
    public static Vec3d getFlowVec(@Nonnull ISpecializedFluidNeighborInfo info) {
        int max = info.getOrigin().getQuantaPerBlock();
        int decay = max - info.getEffectiveQuanta(0, 0, 0);
        EnumFacing down = info.getOrigin().getDownDensityFace();
        EnumFacing up = info.getOrigin().getUpDensityFace();
        Vec3d vec = Vec3d.field_186680_a;
        for (EnumFacing side : EnumFacing.field_176754_o) {
            int power;
            int zo;
            int xo;
            if (!info.canFluidFlow(0, 0, 0, side) || info.isCompatibleFluid(xo = side.func_82601_c(), 0, zo = side.func_82599_e()) && !info.canFluidFlow(xo, 0, zo, side.func_176734_d())) continue;
            int otherDecay = max - info.getEffectiveQuanta(xo, 0, zo);
            if (otherDecay >= max) {
                if (!info.canFluidFlow(xo, 0, zo, down) || info.isCompatibleFluid(xo, -1, zo) && !info.canFluidFlow(xo, -1, zo, up) || (otherDecay = max - info.getEffectiveQuanta(xo, -1, zo)) >= max) continue;
                power = otherDecay - (decay - max);
                vec = vec.func_72441_c((double)(xo * power), 0.0, (double)(zo * power));
                continue;
            }
            power = otherDecay - decay;
            vec = vec.func_72441_c((double)(xo * power), 0.0, (double)(zo * power));
        }
        return vec.func_72432_b();
    }

    public static void updateClassic(@Nonnull World world, @Nonnull BlockPos origin, @Nonnull FluidState originState) {
        int flowCost = originState.getFlowCost(world);
        int slopeDist = originState.getQuantaPerBlock() >> flowCost;
        if (world.field_72995_K || !world.func_175697_a(origin, slopeDist) || !originState.isValid()) {
            return;
        }
        IFluidUpdateHelper.Forge helper = new IFluidUpdateHelper.Forge((IBlockAccess)world, origin, originState, slopeDist);
        int quantaRemaining = originState.getQuantaPerBlock() - originState.getLevel();
        if (quantaRemaining < originState.getQuantaPerBlock()) {
            int expQuanta;
            int adjacentSourceBlocks = 0;
            if (originState.getQuantaPerBlock() > 0 && FluidloggedUtils.canCreateSource(originState.getState(), world, origin) && (helper.getBlockState(0, -1, 0).func_185904_a().func_76220_a() || !helper.canFluidFlow(0, 0, 0, originState.getDownDensityFace()) || helper.isSource(0, -1, 0, originState.getUpDensityFace()))) {
                for (EnumFacing side : EnumFacing.field_176754_o) {
                    if (!helper.canFluidFlow(0, 0, 0, side) || !helper.isSource(side.func_82601_c(), 0, side.func_82599_e(), side.func_176734_d())) continue;
                    ++adjacentSourceBlocks;
                }
            }
            if (adjacentSourceBlocks >= 2 && (helper.getBlockState(0, -1, 0).func_185904_a().func_76220_a() || !helper.canFluidFlow(0, 0, 0, originState.getDownDensityFace()) || helper.isSource(0, -1, 0, originState.getUpDensityFace()))) {
                expQuanta = originState.getQuantaPerBlock();
            } else if (helper.hasVerticalFlow(0, 0, 0)) {
                expQuanta = originState.getQuantaPerBlock() - flowCost;
            } else {
                int maxQuanta = -100;
                if (originState.getQuantaPerBlock() > 0) {
                    for (EnumFacing side : EnumFacing.field_176754_o) {
                        if (!helper.canFluidFlow(0, 0, 0, side) || !helper.canFluidFlow(side.func_82601_c(), 0, side.func_82599_e(), side.func_176734_d())) continue;
                        maxQuanta = Math.max(helper.getEffectiveQuanta(side.func_82601_c(), 0, side.func_82599_e()), maxQuanta);
                    }
                }
                expQuanta = maxQuanta - flowCost;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                helper.setFluid(0, 0, 0, expQuanta <= 0 ? FluidState.EMPTY : originState.withLevel(originState.getQuantaPerBlock() - expQuanta), expQuanta <= 0, originState.getBlock().func_149738_a(world));
                helper.resetDataAt(0, 0, 0);
            }
        }
        if (helper.getFluidState(0, 0, 0).isEmpty()) {
            return;
        }
        if (!(!helper.canFlowInto(0, 0, 0, flowCost, originState.getDownDensityFace(), true, false) || helper.getFluidState(0, 0, 0).isSource() && helper.isCompatibleFluid(0, -1, 0))) {
            helper.flowInto(0, 0, 0, flowCost, originState.getDownDensityFace(), true, false, 3);
            return;
        }
        int flowMeta = originState.getQuantaPerBlock() - quantaRemaining + flowCost;
        if (flowMeta >= originState.getQuantaPerBlock()) {
            return;
        }
        if (flowMeta >= 0 && (helper.getFluidState(0, 0, 0).isSource() || !helper.canFlowInto(0, 0, 0, flowCost, originState.getDownDensityFace(), true, true))) {
            if (helper.hasVerticalFlow(0, 0, 0)) {
                flowMeta = flowCost;
            }
            int[] flowTo = helper.getOptimalFlowDirections(0, 0, 0, originState.getQuantaPerBlock(), flowMeta, flowCost, levelIn -> flowCost);
            for (int i = 0; i < 4; ++i) {
                if (flowTo[i] <= -1) continue;
                EnumFacing side = EnumFacing.field_176754_o[i];
                helper.flowInto(0, 0, 0, flowTo[i], side, true, false, 3);
            }
        }
    }

    public static void updateDynamic(@Nonnull World world, @Nonnull BlockPos origin, @Nonnull FluidState originState, @Nonnull Random rand) {
        int flowCost = originState.getFlowCost(world);
        int slopeDist = originState.getQuantaPerBlock() >> flowCost;
        if (world.field_72995_K || !world.func_175697_a(origin, slopeDist)) {
            return;
        }
        IFluidUpdateHelper.Vanilla helper = new IFluidUpdateHelper.Vanilla((IBlockAccess)world, origin, originState, slopeDist);
        int tickRate = originState.getBlock().func_149738_a(world);
        int level = originState.getLevel();
        boolean placeStatic = true;
        if (level > 0) {
            int currentMinLevel = -100;
            int adjacentSourceBlocks = 0;
            for (EnumFacing side : EnumFacing.field_176754_o) {
                int zo;
                int xo;
                if (!helper.canFluidFlow(0, 0, 0, side) || !helper.isCompatibleFluid(xo = side.func_82601_c(), 0, zo = side.func_82599_e()) || !helper.canFluidFlow(xo, 0, zo, side.func_176734_d())) continue;
                int neighborLevel = helper.getFluidState(xo, 0, zo).getLevel();
                if (neighborLevel == 0) {
                    ++adjacentSourceBlocks;
                } else if (neighborLevel >= 8) {
                    neighborLevel = 0;
                }
                currentMinLevel = currentMinLevel >= 0 && neighborLevel > currentMinLevel ? currentMinLevel : neighborLevel;
            }
            int newLevel = currentMinLevel + flowCost;
            if (newLevel >= 8 || currentMinLevel < 0) {
                newLevel = -1;
            }
            if (helper.hasVerticalFlow(0, 0, 0)) {
                int upLevel = helper.getFluidState(0, 1, 0).getLevel();
                newLevel = upLevel >= 8 ? upLevel : upLevel + 8;
            }
            if (adjacentSourceBlocks >= 2 && FluidloggedUtils.canCreateSource(originState.getState(), world, origin) && (helper.getBlockState(0, -1, 0).func_185904_a().func_76220_a() || !helper.canFluidFlow(0, 0, 0, originState.getDownDensityFace()) || helper.isSource(0, -1, 0, originState.getUpDensityFace()))) {
                newLevel = 0;
            }
            if (originState.getMaterial() == Material.field_151587_i && newLevel < 8 && newLevel > level && rand.nextInt(4) != 0) {
                tickRate <<= 2;
            }
            if (level != newLevel) {
                level = newLevel;
                placeStatic = false;
                helper.setFluid(0, 0, 0, level < 0 ? FluidState.EMPTY : originState.withLevel(level), level < 0, tickRate);
            }
        }
        if (placeStatic) {
            FluidState fluidState = originState.toStatic();
            if (helper.getBlockState(0, 0, 0) == originState.getState() || helper.vaporize(0, 0, 0, fluidState, null)) {
                world.func_180501_a(origin, fluidState.getState(), 22);
            } else {
                FluidloggedUtils.setFluidState(world, origin, helper.getBlockState(0, 0, 0), fluidState, false, 22);
            }
        }
        helper.resetDataAt(0, 0, 0);
        if (helper.getFluidState(0, 0, 0).isEmpty()) {
            return;
        }
        if ((!FluidloggedAPIConfig.fixBadFluidMixing || helper.canFluidFlow(0, 0, 0, originState.getDownDensityFace())) && originState.getMaterial() == Material.field_151587_i && helper.getBlockState(0, -1, 0).func_185904_a() == Material.field_151586_h) {
            world.func_175656_a((BlockPos)helper.getCache().offset((Vec3i)origin, originState.getDownDensityFace().func_176730_m()), ForgeEventFactory.fireFluidPlaceBlockEvent((World)world, (BlockPos)helper.getCache().mutablePos, (BlockPos)origin, (IBlockState)Blocks.field_150348_b.func_176223_P()));
            ((BlockLiquid)originState.getBlock()).func_180688_d(world, (BlockPos)helper.getCache().mutablePos);
            return;
        }
        if (!(!helper.canFlowInto(0, 0, 0, level >= 8 ? level : level + 8, originState.getDownDensityFace(), true, false) || helper.getFluidState(0, 0, 0).isSource() && helper.isCompatibleFluid(0, -1, 0))) {
            helper.flowInto(0, 0, 0, level >= 8 ? level : level + 8, originState.getDownDensityFace(), true, false, 3);
            return;
        }
        if (level >= 0 && (helper.getFluidState(0, 0, 0).isSource() || !helper.canFlowInto(0, 0, 0, level >= 8 ? level : level + 8, originState.getDownDensityFace(), true, true))) {
            int newLevel;
            int n = newLevel = level >= 8 ? flowCost : level + flowCost;
            if (newLevel < 8) {
                int[] flowTo = helper.getOptimalFlowDirections(0, 0, 0, 8, newLevel, flowCost, levelIn -> levelIn >= 8 ? levelIn : levelIn + 8);
                for (int i = 0; i < 4; ++i) {
                    if (flowTo[i] <= -1) continue;
                    EnumFacing side = EnumFacing.field_176754_o[i];
                    helper.flowInto(0, 0, 0, flowTo[i], side, true, false, 3);
                }
            }
        }
    }

    public static void updateFinite(@Nonnull World world, @Nonnull BlockPos origin, @Nonnull FluidState originState, @Nonnull Random rand) {
        int tickRate = originState.getBlock().func_149738_a(world);
        boolean changed = false;
        int quantaRemaining = originState.getQuantaValue();
        IFluidUpdateHelper.Forge helper = new IFluidUpdateHelper.Forge((IBlockAccess)world, origin, originState, 1);
        if (helper.canFluidFlow(0, 0, 0, originState.getDownDensityFace())) {
            BlockPos below = origin.func_177981_b(originState.getDensityDir());
            if (world.func_189509_E(below)) {
                FluidloggedUtils.setFluidToAir(world, origin, null, 3);
                return;
            }
            int prevRemaining = quantaRemaining;
            int amt = originState.getQuantaValueBelow(helper.getCache(), below, originState.getQuantaPerBlock());
            if (amt >= 0) {
                if ((amt += quantaRemaining) > originState.getQuantaPerBlock()) {
                    if (helper.flowInto(0, 0, 0, originState.getQuantaPerBlock() - 1, originState.getDownDensityFace(), false, true, 3)) {
                        world.func_175684_a(below, originState.getBlock(), tickRate);
                        quantaRemaining = amt - originState.getQuantaPerBlock();
                    }
                } else if (amt > 0 && helper.flowInto(0, 0, 0, amt - 1, originState.getDownDensityFace(), false, true, 3)) {
                    world.func_175684_a(below, originState.getBlock(), tickRate);
                    FluidloggedUtils.setFluidToAir(world, origin, null, 3);
                    return;
                }
            } else {
                Object fluidToSwap;
                int density_other = BlockFluidBase.getDensity((IBlockAccess)helper.getCache(), (BlockPos)below);
                if (density_other == Integer.MAX_VALUE) {
                    if (helper.flowInto(0, 0, 0, quantaRemaining - 1, originState.getDownDensityFace(), true, true, 3)) {
                        world.func_175684_a(below, originState.getBlock(), tickRate);
                        FluidloggedUtils.setFluidToAir(world, origin, null, 3);
                        return;
                    }
                } else if (helper.canFluidFlow(0, -1, 0, originState.getUpDensityFace()) && (originState.getDensityDir() < 0 ? density_other < originState.getDensity() : density_other > originState.getDensity()) && ((FluidState)((Object)(fluidToSwap = helper.getFluidState(0, -1, 0)))).isValid() && (!(((FluidState)((Object)fluidToSwap)).getBlock() instanceof IConditionalFluid) || !((IConditionalFluid)((FluidState)((Object)fluidToSwap)).getBlock()).cannotFlowAt(helper.getCache(), origin, (FluidState)((Object)fluidToSwap))) && (helper.getBlockState(0, -1, 0) == ((FluidState)((Object)fluidToSwap)).getState() || helper.isReplaceable(0, -1, 0, originState.withLevel(quantaRemaining - 1), null, false, true) || helper.isFluidloggable(0, -1, 0, originState.withLevel(quantaRemaining - 1), null, false, true))) {
                    SpecializedFluidNeighborInfo toSwapHelper;
                    SpecializedFluidNeighborInfo specializedFluidNeighborInfo = toSwapHelper = ((FluidState)((Object)fluidToSwap)).getBlock() instanceof BlockLiquid ? new IFluidUpdateHelper.Vanilla(helper.getCache(), origin, (FluidState)((Object)fluidToSwap), 1) : new IFluidUpdateHelper.Forge(helper.getCache(), origin, (FluidState)((Object)fluidToSwap), 1);
                    if (toSwapHelper.getBlockState(0, 0, 0) == originState.getState() || toSwapHelper.isReplaceable(0, 0, 0, (FluidState)((Object)fluidToSwap), null, false, true) || toSwapHelper.isFluidloggable(0, 0, 0, (FluidState)((Object)fluidToSwap), null, false, true)) {
                        helper.flowInto(0, 0, 0, quantaRemaining - 1, originState.getDownDensityFace(), false, true, 3);
                        toSwapHelper.flowInto(0, -1, 0, ((FluidState)((Object)fluidToSwap)).getLevel(), originState.getUpDensityFace(), false, true, 3);
                        world.func_175684_a(below, originState.getBlock(), tickRate);
                        world.func_175684_a(origin, ((FluidState)((Object)fluidToSwap)).getBlock(), ((FluidState)((Object)fluidToSwap)).getBlock().func_149738_a(world));
                        return;
                    }
                }
            }
            if (quantaRemaining < 1) {
                return;
            }
            if (quantaRemaining != prevRemaining) {
                changed = true;
                if (quantaRemaining == 1) {
                    helper.setFluid(0, 0, 0, originState.withLevel(0), false, 0);
                }
            } else if (quantaRemaining == 1) {
                return;
            }
        } else if (quantaRemaining == 1) {
            return;
        }
        int lowerThan = quantaRemaining - 1;
        int total = quantaRemaining;
        int count = 1;
        ArrayList<EnumFacing> sides = new ArrayList<EnumFacing>();
        for (EnumFacing side : EnumFacing.field_176754_o) {
            if (!helper.canFlowInto(0, 0, 0, lowerThan, side, true, false)) continue;
            sides.add(side);
            ++count;
            total += Math.max(originState.getQuantaValueBelow(helper.getCache(), origin.func_177972_a(side), lowerThan), 0);
        }
        if (count == 1) {
            if (changed) {
                helper.setFluid(0, 0, 0, originState.withLevel(quantaRemaining - 1), false, 0);
            }
            return;
        }
        int each = total / count;
        int rem = total % count;
        for (EnumFacing side : sides) {
            int quanta;
            BlockPos off = origin.func_177972_a(side);
            int newQuanta = each;
            if (rem == count || rem > 1 && rand.nextInt(count - rem) != 0) {
                ++newQuanta;
                --rem;
            }
            if ((quanta = Math.max(0, originState.getQuantaValue(helper.getCache(), off))) < lowerThan && newQuanta != quantaRemaining) {
                if (newQuanta == 0) {
                    FluidloggedUtils.setFluidToAir(world, off, helper.getBlockState(side.func_82601_c(), 0, side.func_82599_e()), 3);
                } else if (helper.flowInto(0, 0, 0, newQuanta - 1, side, true, false, 2)) {
                    world.func_175684_a(off, originState.getBlock(), tickRate);
                    changed = true;
                }
            }
            --count;
        }
        if (rem > 0) {
            ++each;
        }
        if (changed) {
            helper.setFluid(0, 0, 0, originState.withLevel(each - 1), false, 0);
        }
    }
}

