/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.datafix;

import com.google.common.collect.ImmutableMap;
import git.jbredwards.fluidlogged_api.mod.FluidloggedAPI;
import git.jbredwards.fluidlogged_api.mod.common.datafix.FluidloggedAPIFixableData;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="fluidlogged_api")
public final class LegacyDataFixer {
    private static Int2ObjectMap<String> FLUID_MAPPINGS = null;
    private static Int2ObjectMap<Block> FLUID_ID_MAPPINGS = null;

    public static void init() {
        FLUID_MAPPINGS = new Int2ObjectOpenHashMap();
        FLUID_ID_MAPPINGS = new Int2ObjectOpenHashMap();
    }

    public static void reset() {
        FLUID_MAPPINGS = null;
        FLUID_ID_MAPPINGS = null;
    }

    @SubscribeEvent
    public static void onMissingBlockMappings(@Nonnull RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (!mapping.key.func_110623_a().endsWith("logged_te")) continue;
            FLUID_MAPPINGS.put(mapping.id, (Object)mapping.key.func_110623_a().replace("logged_te", ""));
            mapping.ignore();
        }
    }

    @Nullable
    private static Block getFluidByOldName(int blockID) {
        return (Block)FLUID_ID_MAPPINGS.computeIfAbsent((Object)blockID, block -> {
            String mapping = (String)FLUID_MAPPINGS.get(blockID);
            if (mapping != null) {
                Fluid fluid = FluidRegistry.getFluid((String)mapping);
                if (fluid != null) {
                    return fluid.getBlock();
                }
                FluidloggedAPI.LOGGER.error("Can't find fluid: " + mapping);
            } else {
                FluidloggedAPI.LOGGER.error("Can't find fluid from id: " + blockID);
            }
            return null;
        });
    }

    @Nonnull
    public static NBTTagCompound fix(@Nonnull NBTTagCompound compound) {
        if (!FLUID_MAPPINGS.isEmpty()) {
            int sectionY;
            NBTTagCompound level = compound.func_74775_l("Level");
            NBTTagList tileEntities = level.func_150295_c("TileEntities", 10);
            Int2ObjectOpenHashMap legacyTiles = new Int2ObjectOpenHashMap();
            ImmutableMap legacyDataGetters = ImmutableMap.of((Object)"fluidlogged_api:te", FluidloggedAPIDataAdapter::new, (Object)"njarm:waterlogged_te", NJARM2DataAdapter::new);
            Iterator it = tileEntities.iterator();
            while (it.hasNext()) {
                NBTTagCompound nbt = (NBTTagCompound)it.next();
                Function dataGetter = (Function)legacyDataGetters.get(nbt.func_74779_i("id"));
                if (dataGetter == null) continue;
                BlockPos pos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
                sectionY = pos.func_177956_o() >> 4;
                ArrayList<Pair> list = (ArrayList<Pair>)legacyTiles.get(sectionY);
                if (list == null) {
                    list = new ArrayList<Pair>();
                    legacyTiles.put(sectionY, list);
                }
                list.add(Pair.of((Object)pos, dataGetter.apply(nbt)));
                it.remove();
            }
            if (!legacyTiles.isEmpty()) {
                NBTTagList cap = FluidloggedAPIFixableData.getOrCreateFluidCapabilityData(level);
                NBTTagList sections = level.func_150295_c("Sections", 10);
                for (int i = 0; i < sections.func_74745_c(); ++i) {
                    NBTTagCompound section = sections.func_150305_b(i);
                    sectionY = section.func_74771_c("Y");
                    List sectionLegacyTiles = (List)legacyTiles.get(sectionY);
                    if (sectionLegacyTiles == null) continue;
                    NibbleArray metadataArray = new NibbleArray(section.func_74770_j("Data"));
                    byte[] blockIDs = section.func_74770_j("Blocks");
                    NibbleArray extIDs = section.func_150297_b("Add", 7) ? new NibbleArray(section.func_74770_j("Add")) : new NibbleArray();
                    for (Pair entry : sectionLegacyTiles) {
                        boolean needFluidStateAddition;
                        BlockPos pos = (BlockPos)entry.getKey();
                        int x = pos.func_177958_n() & 0xF;
                        int y = pos.func_177956_o() & 0xF;
                        int z = pos.func_177952_p() & 0xF;
                        int blockIndex = y << 8 | z << 4 | x;
                        int blockID = extIDs.func_76582_a(x, y, z) << 8 | blockIDs[blockIndex] & 0xFF;
                        Block containedBlock = Block.func_149684_b((String)((LegacyDataGetter)entry.getValue()).getContainedBlock());
                        int containedMeta = ((LegacyDataGetter)entry.getValue()).getContainedMetadata();
                        Block fluid = LegacyDataFixer.getFluidByOldName(blockID);
                        boolean bl = needFluidStateAddition = containedBlock != null;
                        if (!needFluidStateAddition) {
                            FluidloggedAPI.LOGGER.error("warning: can't find block \"" + ((LegacyDataGetter)entry.getValue()).getContainedBlock() + "\" at " + pos + ", trying to only place fluid in world");
                            if (fluid != null) {
                                containedBlock = fluid;
                                containedMeta = 0;
                            }
                        }
                        if (containedBlock != null) {
                            int blockStateID = Block.field_176229_d.func_148747_b((Object)containedBlock.func_176203_a(containedMeta));
                            blockIDs[blockIndex] = (byte)(blockStateID >> 4 & 0xFF);
                            metadataArray.func_76581_a(x, y, z, containedMeta);
                            extIDs.func_76581_a(x, y, z, blockStateID >> 12 & 0xF);
                        }
                        if (!needFluidStateAddition || fluid == null) continue;
                        NBTTagCompound nbt = new NBTTagCompound();
                        nbt.func_74778_a("id", String.valueOf(fluid.getRegistryName()));
                        nbt.func_74772_a("pos", pos.func_177986_g());
                        cap.func_74742_a((NBTBase)nbt);
                    }
                    section.func_74773_a("Blocks", blockIDs);
                    section.func_74773_a("Data", metadataArray.func_177481_a());
                    section.func_74773_a("Add", extIDs.func_177481_a());
                    legacyTiles.remove(sectionY);
                    if (!legacyTiles.isEmpty()) continue;
                    return compound;
                }
            }
        }
        return compound;
    }

    static class NJARM2DataAdapter
    implements LegacyDataGetter {
        @Nonnull
        final NBTTagCompound nbt;

        NJARM2DataAdapter(@Nonnull NBTTagCompound nbtIn) {
            this.nbt = nbtIn;
        }

        @Override
        @Nonnull
        public String getContainedBlock() {
            return this.nbt.func_74779_i("StoredId");
        }

        @Override
        public int getContainedMetadata() {
            return this.nbt.func_74762_e("StoredMeta");
        }
    }

    static class FluidloggedAPIDataAdapter
    implements LegacyDataGetter {
        @Nonnull
        final NBTTagCompound stored;

        FluidloggedAPIDataAdapter(@Nonnull NBTTagCompound nbtIn) {
            this.stored = nbtIn.func_74775_l("Stored");
        }

        @Override
        @Nonnull
        public String getContainedBlock() {
            return this.stored.func_74779_i("id");
        }

        @Override
        public int getContainedMetadata() {
            return this.stored.func_74762_e("meta");
        }
    }

    static interface LegacyDataGetter {
        @Nonnull
        public String getContainedBlock();

        public int getContainedMetadata();
    }
}

