/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.config.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.FluidloggedAPI;
import git.jbredwards.fluidlogged_api.mod.asm.iface.ICanFluidFlowHandler;
import git.jbredwards.fluidlogged_api.mod.asm.iface.IConfigAccessor;
import git.jbredwards.fluidlogged_api.mod.asm.iface.IConfigFluidBox;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfigs;
import git.jbredwards.fluidlogged_api.mod.common.config.util.ConfigPredicateHelper;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@FunctionalInterface
public interface ConfigPredicate {
    @Nonnull
    public static final ConfigPredicate ALWAYS = (world, pos, state, fluidState) -> true;
    @Nonnull
    public static final ConfigPredicate TRUE_FOR_SOURCE = (world, pos, state, fluidState) -> fluidState.isSource();
    @Nonnull
    public static final ConfigPredicate TRUE_FOR_SIDE = (world, pos, state, fluidState) -> fluidState.isSource() || FluidloggedUtils.canFluidOccupy(state, world, pos, fluidState);
    public static final Multimap<Class<?>, Block> CLASS_TO_BLOCK = HashMultimap.create();
    public static final Multimap<String, Block> MODID_TO_BLOCK = HashMultimap.create();

    public static void fillClassToBlockLookup() {
        if (CLASS_TO_BLOCK.isEmpty()) {
            ForgeRegistries.BLOCKS.forEach(b -> {
                Class<Block> c = b.getClass();
                while (!c.isAssignableFrom(Block.class)) {
                    for (Class<?> iface : c.getInterfaces()) {
                        CLASS_TO_BLOCK.put(iface, b);
                    }
                    CLASS_TO_BLOCK.put(c, b);
                    c = c.getSuperclass();
                }
            });
        }
    }

    public static void fillModIdToBlockLookup() {
        if (MODID_TO_BLOCK.isEmpty()) {
            ForgeRegistries.BLOCKS.getEntries().forEach(e -> MODID_TO_BLOCK.put((Object)((ResourceLocation)e.getKey()).func_110624_b(), e.getValue()));
        }
    }

    public boolean test(@Nonnull IBlockAccess var1, @Nonnull BlockPos var2, @Nonnull IBlockState var3, @Nonnull FluidState var4);

    public static void deserialize(@Nonnull String fileName, @Nonnull JsonObject json, @Nonnull ConfigGetter configGetter, @Nonnull ConfigSetter configSetter, @Nonnull UnaryOperator<ICanFluidFlowHandler> flowTransformer) {
        ConfigPredicateHelper helper = new ConfigPredicateHelper(json, flowTransformer);
        if (json.has("classId")) {
            FluidloggedAPIConfigs.getAsIterable(json.get("classId"), JsonElement::getAsString).forEach(classId -> {
                Class<Block> blockClass;
                try {
                    blockClass = Class.forName(classId);
                }
                catch (ClassNotFoundException e) {
                    if (json.has("allowMissing") && JsonUtils.func_151216_b((JsonElement)json.get("allowMissing"), (String)"allowMissing")) {
                        return;
                    }
                    FluidloggedAPI.LOGGER.warn(String.format("Could not get class from \"%s\" in file \"%s\", skipping...", classId, fileName), (Throwable)e);
                    return;
                }
                if (blockClass.isAssignableFrom(Block.class)) {
                    FluidloggedAPI.LOGGER.warn((Object)new JsonParseException(String.format("Class \"%s\" is too broad in file \"%s\", skipping...", classId, fileName)));
                    return;
                }
                ConfigPredicate.fillClassToBlockLookup();
                Collection blocks = CLASS_TO_BLOCK.get(blockClass);
                if (!blocks.isEmpty()) {
                    blocks.forEach(block -> {
                        try {
                            helper.forEachState((Block)block, configGetter, configSetter);
                        }
                        catch (Throwable t) {
                            String error = "An error has occurred while deserializing config predicate for \"%s\" of class \"%s\" in file \"%s\", skipping...";
                            FluidloggedAPI.LOGGER.warn(String.format("An error has occurred while deserializing config predicate for \"%s\" of class \"%s\" in file \"%s\", skipping...", block.getRegistryName(), classId, fileName), t);
                        }
                    });
                } else if (!json.has("allowMissing") || !JsonUtils.func_151216_b((JsonElement)json.get("allowMissing"), (String)"allowMissing")) {
                    FluidloggedAPI.LOGGER.warn((Object)new JsonParseException(String.format("Could not get any blocks from class \"%s\" in file \"%s\".", classId, fileName)));
                }
            });
        } else if (json.has("modId")) {
            FluidloggedAPIConfigs.getAsIterable(json.get("modId"), JsonElement::getAsString).forEach(modId -> {
                ConfigPredicate.fillModIdToBlockLookup();
                Collection blocks = MODID_TO_BLOCK.get(modId);
                if (!blocks.isEmpty()) {
                    blocks.forEach(block -> {
                        try {
                            helper.forEachState((Block)block, configGetter, configSetter);
                        }
                        catch (Throwable t) {
                            String error = "An error has occurred while deserializing config predicate for \"%s\" from mod id \"%s\" in file \"%s\", skipping...";
                            FluidloggedAPI.LOGGER.warn(String.format("An error has occurred while deserializing config predicate for \"%s\" from mod id \"%s\" in file \"%s\", skipping...", block.getRegistryName(), modId, fileName), t);
                        }
                    });
                } else if (!json.has("allowMissing") || !JsonUtils.func_151216_b((JsonElement)json.get("allowMissing"), (String)"allowMissing")) {
                    FluidloggedAPI.LOGGER.warn((Object)new JsonParseException(String.format("Could not get any blocks from mod id \"%s\" in file \"%s\".", modId, fileName)));
                }
            });
        } else {
            if (!json.has("blockId")) {
                throw new JsonParseException("Missing \"blockId\" for config predicate entry: " + json);
            }
            FluidloggedAPIConfigs.getAsIterable(json.get("blockId"), JsonElement::getAsString).forEach(blockId -> {
                Block block = Block.func_149684_b((String)blockId);
                if (block == null) {
                    if (json.has("allowMissing") && JsonUtils.func_151216_b((JsonElement)json.get("allowMissing"), (String)"allowMissing")) {
                        return;
                    }
                    FluidloggedAPI.LOGGER.warn((Object)new JsonParseException(String.format("Could not get block from \"%s\" in file \"%s\", skipping...", blockId, fileName)));
                    return;
                }
                try {
                    helper.forEachState(block, configGetter, configSetter);
                }
                catch (Throwable t) {
                    String error = "An error has occurred while deserializing config predicate for \"%s\" in file \"%s\", skipping...";
                    FluidloggedAPI.LOGGER.warn(String.format("An error has occurred while deserializing config predicate for \"%s\" in file \"%s\", skipping...", blockId, fileName), t);
                }
            });
        }
    }

    public static void reset() {
        Iterables.concat(IConfigAccessor.BLACKLIST_CACHE, IConfigAccessor.WHITELIST_CACHE).forEach(a -> {
            a.setBlacklistPredicate(null);
            a.setWhitelistPredicate(null);
            ((IConfigFluidBox)((Object)a)).setBoxes(null);
            ICanFluidFlowHandler.Accessor.setOverride(a, null);
        });
        IConfigAccessor.BLACKLIST_CACHE.clear();
        IConfigAccessor.WHITELIST_CACHE.clear();
    }

    @FunctionalInterface
    public static interface ConfigSetter
    extends BiConsumer<IConfigAccessor, ConfigPredicate> {
    }

    @FunctionalInterface
    public static interface ConfigGetter
    extends Function<IConfigAccessor, ConfigPredicate> {
    }
}

