/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.config.handler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.MalformedJsonException;
import git.jbredwards.fluidlogged_api.mod.FluidloggedAPI;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfigs;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public final class OnlineConfigHandler {
    @Nonnull
    static final Path readmePath = FluidloggedAPIConfigs.FOLDER.resolve("internal/README.txt");
    @Nonnull
    static final Path versionsPath = FluidloggedAPIConfigs.FOLDER.resolve("internal/versions.jsonc");
    @Nonnull
    static final String readmeURL = "https://raw.githubusercontent.com/jbredwards/Fluidlogged-API-Configs/refs/heads/1.12.2/internal/README.txt";
    @Nonnull
    static final String versionsURL = "https://raw.githubusercontent.com/jbredwards/Fluidlogged-API-Configs/refs/heads/1.12.2/internal/versions.jsonc";
    @Nonnull
    static final String autoConfigURL = "https://raw.githubusercontent.com/jbredwards/Fluidlogged-API-Configs/refs/heads/1.12.2/internal/%s/%s";

    public static void downloadModConfigs() throws IOException {
        JsonObject newVersions;
        JsonObject oldVersions;
        if (FluidloggedAPIConfig.downloadModConfigs != FluidloggedAPIConfig.OnlineConfigMode.KEEP_UPDATED) {
            return;
        }
        try (InputStream stream = new URL(readmeURL).openStream();){
            OnlineConfigHandler.createFile(readmePath, stream);
        }
        if (!Files.exists(versionsPath, new LinkOption[0])) {
            oldVersions = new JsonObject();
        } else {
            try {
                BufferedReader reader = Files.newBufferedReader(versionsPath);
                Object object = null;
                try {
                    oldVersions = new JsonParser().parse((Reader)reader).getAsJsonObject();
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        if (object != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((Reader)reader).close();
                        }
                    }
                }
            }
            catch (JsonParseException | MalformedJsonException | IllegalStateException e) {
                Files.copy(versionsPath, versionsPath.resolveSibling("versions.jsonc.old"), StandardCopyOption.REPLACE_EXISTING);
                FluidloggedAPI.LOGGER.info("The file \"{}\" has been corrupted. Re-downloading Fluidlogged API community configs...", (Object)versionsPath);
                FluidloggedAPI.LOGGER.error((Object)e);
                oldVersions = new JsonObject();
            }
        }
        try (InputStream stream = new URL(versionsURL).openStream();){
            OnlineConfigHandler.createFile(versionsPath, stream);
        }
        var3_9 = null;
        try (BufferedReader reader = Files.newBufferedReader(versionsPath);){
            newVersions = new JsonParser().parse((Reader)reader).getAsJsonObject();
        }
        catch (Throwable throwable) {
            var3_9 = throwable;
            throw throwable;
        }
        for (ModContainer mod : Loader.instance().getModList()) {
            String modid = mod.getModId().replaceAll("[<>:\"|?*]", "_");
            JsonElement newElement = newVersions.get(modid);
            JsonElement oldElement = oldVersions.get(modid);
            Path folder = FluidloggedAPIConfigs.FOLDER.resolve(Paths.get("internal", modid));
            if (newElement == null) {
                if (oldElement == null) continue;
                FileUtils.deleteDirectory((File)folder.toFile());
                continue;
            }
            if (oldElement != null && JsonUtils.func_151215_f((JsonElement)oldElement, (String)modid) >= JsonUtils.func_151215_f((JsonElement)newElement, (String)modid) && Files.exists(folder, new LinkOption[0])) continue;
            OnlineConfigHandler.downloadModConfig(folder, modid, "whitelist.jsonc");
            OnlineConfigHandler.downloadModConfig(folder, modid, "blacklist.jsonc");
            OnlineConfigHandler.downloadModConfig(folder, modid, "fluidTags.jsonc");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadModConfig(@Nonnull Path folder, @Nonnull String modid, @Nonnull String config) throws IOException {
        InputStream stream = null;
        try {
            stream = new URL(String.format(autoConfigURL, modid, config)).openStream();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Path path = folder.resolve(config);
        if (stream == null) {
            Files.deleteIfExists(path);
        } else {
            try {
                OnlineConfigHandler.createFile(path, stream);
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }
    }

    private static void createFile(@Nonnull Path path, @Nonnull InputStream data) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
        }
        Files.copy(data, path, StandardCopyOption.REPLACE_EXISTING);
    }
}

