/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import git.jbredwards.fluidlogged_api.api.event.FluidloggedAPIConfigsEvent;
import git.jbredwards.fluidlogged_api.mod.FluidloggedAPI;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import git.jbredwards.fluidlogged_api.mod.common.config.handler.BlacklistConfigHandler;
import git.jbredwards.fluidlogged_api.mod.common.config.handler.FluidTagsConfigHandler;
import git.jbredwards.fluidlogged_api.mod.common.config.handler.OnlineConfigHandler;
import git.jbredwards.fluidlogged_api.mod.common.config.handler.WhitelistConfigHandler;
import git.jbredwards.fluidlogged_api.mod.common.config.util.ConfigPredicate;
import git.jbredwards.fluidlogged_api.mod.common.message.SMessageSyncConfigs;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class FluidloggedAPIConfigs {
    @Nonnull
    public static final Path FOLDER = Loader.instance().getConfigDir().toPath().resolve("fluidlogged_api");

    public static void initConfigs(@Nonnull MinecraftServer server, boolean isReload) throws IOException {
        try {
            OnlineConfigHandler.downloadModConfigs();
        }
        catch (IOException e) {
            FluidloggedAPI.LOGGER.error((Object)e);
        }
        JsonObject configs = FluidloggedAPIConfigs.readConfigFiles(server);
        if (!MinecraftForge.EVENT_BUS.post((Event)new FluidloggedAPIConfigsEvent.Apply(server, configs, isReload))) {
            FluidloggedAPIConfigs.init(configs);
            if (isReload) {
                if (server.func_71262_S()) {
                    FluidloggedAPI.WRAPPER.sendToAll((IMessage)new SMessageSyncConfigs(configs));
                } else if (server.func_184103_al().func_72394_k() > 1) {
                    server.func_184103_al().func_181057_v().forEach(player -> {
                        if (!player.field_71135_a.func_147362_b().func_150731_c()) {
                            FluidloggedAPI.WRAPPER.sendTo((IMessage)new SMessageSyncConfigs(configs), player);
                        }
                    });
                }
            }
        }
    }

    @Nonnull
    public static JsonObject readConfigFiles(@Nonnull MinecraftServer server) {
        JsonObject ret = new JsonObject();
        MinecraftForge.EVENT_BUS.post((Event)new FluidloggedAPIConfigsEvent.Read.Pre(server, ret));
        FluidloggedAPIConfigs.saveToCache(ret, "FLUID_TAGS", "fluidTags");
        FluidloggedAPIConfigs.saveToCache(ret, "WHITELIST", "whitelist");
        FluidloggedAPIConfigs.saveToCache(ret, "BLACKLIST", "blacklist");
        MinecraftForge.EVENT_BUS.post((Event)new FluidloggedAPIConfigsEvent.Read.Post(server, ret));
        return ret;
    }

    private static void saveToCache(@Nonnull JsonObject configs, @Nonnull String type, @Nonnull String fileName) {
        Path file;
        JsonObject json = new JsonObject();
        JsonObject onlineData = new JsonObject();
        JsonObject modData = new JsonObject();
        configs.add(type, (JsonElement)json);
        for (ModContainer mod : Loader.instance().getModList()) {
            String path;
            InputStream folder;
            Path autoConfig;
            String fixedModid = mod.getModId().replaceAll("[<>:\"|?*]", "_");
            if (FluidloggedAPIConfig.downloadModConfigs != FluidloggedAPIConfig.OnlineConfigMode.DISABLED && Files.exists(autoConfig = FOLDER.resolve(Paths.get("internal", fixedModid, fileName + ".jsonc")), new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(autoConfig);){
                    onlineData.add(fixedModid, new JsonParser().parse((Reader)reader));
                }
                catch (Throwable t) {
                    FluidloggedAPI.LOGGER.error("Error occurred while caching " + autoConfig, t);
                }
            }
            if (!FluidloggedAPIConfig.allowDefaults || (folder = Loader.class.getResourceAsStream(path = "/assets/" + fixedModid + "/fluidlogged_api")) == null) continue;
            try {
                folder.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String file2 = path + '/' + fileName;
            InputStream modConfig = Loader.class.getResourceAsStream(file2 + ".cfg");
            if (modConfig == null) {
                modConfig = Loader.class.getResourceAsStream(file2 + ".json");
            }
            if (modConfig == null) {
                modConfig = Loader.class.getResourceAsStream(file2 + ".jsonc");
            }
            if (modConfig == null) {
                modConfig = Loader.class.getResourceAsStream(file2 + ".txt");
            }
            if (modConfig == null) continue;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(modConfig));
                Throwable throwable = null;
                try {
                    modData.add(fixedModid, new JsonParser().parse((Reader)reader));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Throwable t) {
                FluidloggedAPI.LOGGER.error("Error occurred while caching " + file2, t);
            }
        }
        if (onlineData.size() != 0) {
            json.add("ONLINE", (JsonElement)onlineData);
        }
        if (modData.size() != 0) {
            json.add("MODDED", (JsonElement)modData);
        }
        if (Files.exists(file = FOLDER.resolve(fileName + ".cfg"), new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(file);){
                json.add("USER", new JsonParser().parse((Reader)reader));
            }
            catch (Throwable t) {
                FluidloggedAPI.LOGGER.error("Error occurred while caching " + file, t);
            }
        }
    }

    public static void init(@Nonnull JsonObject configs) throws IOException {
        try {
            ConfigPredicate.reset();
            FluidTagsConfigHandler.init(configs);
            WhitelistConfigHandler.init(configs);
            BlacklistConfigHandler.init(configs);
        }
        finally {
            FluidTagsConfigHandler.FLUID_TAGS = null;
        }
    }

    public static void forEach(@Nonnull JsonObject configs, @Nonnull String type, @Nonnull String fileName, @Nonnull BiConsumer<String, JsonElement> action) throws IOException {
        if (!configs.has(type)) {
            return;
        }
        JsonObject json = configs.getAsJsonObject(type);
        if (json.has("ONLINE")) {
            json.getAsJsonObject("ONLINE").entrySet().forEach(e -> {
                String file = FOLDER + "/internal/" + (String)e.getKey() + '/' + fileName;
                try {
                    FluidloggedAPIConfigs.getAsIterable((JsonElement)e.getValue(), Function.identity()).forEach(element -> action.accept(file, (JsonElement)element));
                }
                catch (Throwable t) {
                    FluidloggedAPI.LOGGER.error("Error occurred while interpreting " + file, t);
                }
            });
        }
        if (json.has("MODDED")) {
            json.getAsJsonObject("MODDED").entrySet().forEach(e -> {
                String file = "/assets/" + (String)e.getKey() + "/fluidlogged_api/" + fileName;
                try {
                    FluidloggedAPIConfigs.getAsIterable((JsonElement)e.getValue(), Function.identity()).forEach(element -> action.accept(file, (JsonElement)element));
                }
                catch (Throwable t) {
                    FluidloggedAPI.LOGGER.error("Error occurred while interpreting " + file, t);
                }
            });
        }
        if (json.has("USER")) {
            String file = FOLDER.toString() + '/' + fileName + ".cfg";
            try {
                FluidloggedAPIConfigs.getAsIterable(json.get("USER"), Function.identity()).forEach(element -> action.accept(file, (JsonElement)element));
            }
            catch (Throwable t) {
                FluidloggedAPI.LOGGER.error("Error occurred while interpreting " + file, t);
            }
        }
    }

    @Nonnull
    public static <T> Iterable<T> getAsIterable(final @Nonnull JsonElement json, final @Nonnull Function<JsonElement, T> mapper) {
        return json.isJsonArray() ? () -> new Iterator<T>(){
            @Nonnull
            final Iterator it;
            {
                this.it = json.getAsJsonArray().iterator();
            }

            @Override
            @Nonnull
            public T next() {
                return mapper.apply(this.it.next());
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        } : Collections.singleton(mapper.apply(json));
    }
}

