/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.client;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.FluidloggedAPI;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidRegistry;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginBlockFluidRenderer
implements IASMPlugin {
    private int pos;
    private int f7;
    private int f8;
    private int f9;
    private int f10;
    private int d1;

    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (method.name.equals(obfuscated ? "func_178270_a" : "renderFluid")) {
            this.f7 = this.findLocal((MethodNode)method, (String)"f7", (String)"F").index;
            this.f8 = this.findLocal((MethodNode)method, (String)"f8", (String)"F").index;
            this.f9 = this.findLocal((MethodNode)method, (String)"f9", (String)"F").index;
            this.f10 = this.findLocal((MethodNode)method, (String)"f10", (String)"F").index;
            this.d1 = this.findLocal((MethodNode)method, (String)"d1", (String)"D").index;
            this.pos = 0;
            return 1;
        }
        if (method.name.equals(obfuscated ? "func_178268_a" : "initAtlasSprites")) {
            return 3;
        }
        return method.name.equals(obfuscated ? "func_178269_a" : "getFluidHeight") ? 2 : 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1) {
            if (this.checkMethod(insn, obfuscated ? "func_181662_b" : "pos") && ++this.pos == 12) {
                return true;
            }
            if (insn.getOpcode() == 23 && (((VarInsnNode)insn).var == this.f7 || ((VarInsnNode)insn).var == this.f8 || ((VarInsnNode)insn).var == this.f9 || ((VarInsnNode)insn).var == this.f10)) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("java/lang/Math", "min", "(FF)F"));
                instructions.insert(insn, (AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(0.998f)));
            } else if (this.pos >= 8 && insn.getOpcode() == 24 && ((VarInsnNode)insn).var == this.d1) {
                instructions.insert(insn, (AbstractInsnNode)new InsnNode(99));
                instructions.insert(insn, (AbstractInsnNode)new LdcInsnNode((Object)0.002));
            }
        } else if (index == 2) {
            if (insn.getOpcode() == 25 && ((VarInsnNode)insn).var == 3) {
                if (this.checkMethod(insn.getPrevious(), obfuscated ? "func_185904_a" : "getMaterial")) {
                    this.removeFrom(instructions, insn.getPrevious(), -1);
                    instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 3));
                    instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("matchMaterialIfFluid", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/material/Material;)Lnet/minecraft/block/material/Material;"));
                } else {
                    instructions.remove(insn.getPrevious());
                    instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 15));
                    instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 3));
                    instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("matchMaterialIfFluid", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/material/Material;)Lnet/minecraft/block/material/Material;"));
                }
            } else if (insn.getOpcode() == 58 && ((VarInsnNode)insn).var == 8) {
                instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(58, 15));
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "getFluidOrReal", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/block/state/IBlockState;"));
                instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 8));
                instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 7));
                instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
            } else if (insn.getOpcode() == 25 && ((VarInsnNode)insn).var == 8 && this.checkField(insn.getNext(), obfuscated ? "field_176367_b" : "LEVEL")) {
                ((VarInsnNode)insn).var = 15;
                return true;
            }
        } else if (index == 3 && insn.getOpcode() == 18) {
            if ("minecraft:blocks/water_still".equals(((LdcInsnNode)insn).cst)) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("getWaterStill", "(Ljava/lang/String;)Ljava/lang/String;"));
            } else if ("minecraft:blocks/water_flow".equals(((LdcInsnNode)insn).cst)) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("getWaterFlow", "(Ljava/lang/String;)Ljava/lang/String;"));
            } else if ("minecraft:blocks/water_overlay".equals(((LdcInsnNode)insn).cst)) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("getWaterOverlay", "(Ljava/lang/String;)Ljava/lang/String;"));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean addLocalVariables(@Nonnull MethodNode method, @Nonnull LabelNode start, @Nonnull LabelNode end, int index) {
        method.localVariables.add(new LocalVariableNode("fluidState", "Lnet/minecraft/block/state/IBlockState;", null, start, end, 15));
        return true;
    }

    @Override
    public boolean recalcFrames(boolean obfuscated) {
        return true;
    }

    public static final class Hooks {
        @Nonnull
        public static String getWaterFlow(@Nonnull String original) {
            return FluidloggedAPI.isSubaquatic ? FluidRegistry.WATER.getFlowing().toString() : original;
        }

        @Nonnull
        public static String getWaterOverlay(@Nonnull String original) {
            return FluidloggedAPI.isSubaquatic ? Optional.ofNullable(FluidRegistry.WATER.getOverlay()).map(Object::toString).orElse(original) : original;
        }

        @Nonnull
        public static String getWaterStill(@Nonnull String original) {
            return FluidloggedAPI.isSubaquatic ? FluidRegistry.WATER.getStill().toString() : original;
        }

        @Nonnull
        public static Material matchMaterialIfFluid(@Nonnull IBlockAccess access, @Nonnull BlockPos pos, @Nonnull Material toMatch) {
            return Hooks.matchMaterialIfFluid(FluidloggedUtils.getFluidOrReal(access, pos), toMatch);
        }

        @Nonnull
        public static Material matchMaterialIfFluid(@Nonnull IBlockState fluidState, @Nonnull Material toMatch) {
            return FluidloggedUtils.isCompatibleFluid(FluidloggedUtils.getFluidFromState(fluidState), toMatch == Material.field_151586_h ? FluidRegistry.WATER : FluidRegistry.LAVA) ? toMatch : Material.field_151579_a;
        }
    }
}

