/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.block;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.FluidCache;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginBlockFire
implements IASMPlugin {
    @Override
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return method.name.equals("tryCatchFire");
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (this.checkMethod(insn, "getFlammability")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("getFlammability", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)I"));
            instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 6));
            this.removeFrom(instructions, insn, -5);
        } else if (this.checkMethod(insn, obfuscated ? "func_177226_a" : "withProperty")) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)this.genMethodNode("getFireOrFluid", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/properties/PropertyInteger;Ljava/lang/Integer;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;"));
            instructions.insert(insn, list);
            instructions.remove(insn);
            return true;
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_176538_m" : "getNeighborEncouragement"), "getNeighborEncouragement", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)I", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
        });
        this.overrideMethod(classNode, (MethodNode method) -> this.checkMethod((MethodNode)method, "canCatchFire", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Z"), "canCatchFire", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Z", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
        });
        return true;
    }

    public static final class Hooks {
        public static boolean canCatchFire(@Nonnull IBlockAccess access, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
            FluidCache cache = new FluidCache(access, (Vec3i)pos, 0, 0);
            IBlockState state = cache.func_180495_p(pos);
            boolean blockFlammable = state.func_177230_c().isFlammable((IBlockAccess)cache, pos, side);
            if (!blockFlammable) {
                return false;
            }
            if (FluidloggedUtils.isFluid(state) || !FluidloggedAPIConfig.fluidStateIsFireInsulator) {
                return true;
            }
            FluidState fluidState = cache.getFluidState((Vec3i)pos);
            return fluidState == FluidState.EMPTY || fluidState.getMaterial() == Material.field_151587_i || fluidState.getBlock().isFlammable((IBlockAccess)cache, pos, side);
        }

        @Nonnull
        public static IBlockState getFireOrFluid(@Nonnull IBlockState fire, @Nonnull PropertyInteger ageProp, @Nonnull Integer newAge, @Nonnull World world, @Nonnull BlockPos pos) {
            FluidState fluidState = FluidState.get((IBlockAccess)world, pos);
            return fluidState == FluidState.EMPTY || fluidState.getMaterial().func_76217_h() ? fire.func_177226_a((IProperty)ageProp, (Comparable)newAge) : fluidState.getState();
        }

        public static int getFlammability(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
            Chunk chunk = world.func_175726_f(pos);
            IBlockState state = chunk.func_177435_g(pos);
            int blockFlammability = state.func_177230_c().getFlammability((IBlockAccess)world, pos, side);
            if (blockFlammability == 0) {
                return 0;
            }
            if (FluidloggedUtils.isFluid(state)) {
                return blockFlammability;
            }
            FluidState fluidState = FluidState.getFromProvider((ICapabilityProvider)chunk, pos);
            if (fluidState == FluidState.EMPTY || fluidState.getMaterial() == Material.field_151587_i) {
                return blockFlammability;
            }
            int fluidFlammability = fluidState.getBlock().getFlammability((IBlockAccess)world, pos, side);
            if (fluidFlammability == 0) {
                return FluidloggedAPIConfig.fluidStateIsFireInsulator ? 0 : blockFlammability;
            }
            return blockFlammability + fluidFlammability;
        }

        public static int getNeighborEncouragement(@Nonnull World world, @Nonnull BlockPos pos) {
            FluidCache cache = new FluidCache((IBlockAccess)world, (Vec3i)pos, 1, 1);
            if (!cache.func_175623_d(pos)) {
                return 0;
            }
            int maxEncouragement = 0;
            for (EnumFacing side : EnumFacing.field_82609_l) {
                BlockPos offset = pos.func_177972_a(side);
                IBlockState state = cache.func_180495_p(pos);
                int blockEncouragement = state.func_177230_c().getFireSpreadSpeed((IBlockAccess)cache, offset, side.func_176734_d());
                if (blockEncouragement == 0) continue;
                if (FluidloggedUtils.isFluid(state)) {
                    maxEncouragement = Math.max(blockEncouragement, maxEncouragement);
                    continue;
                }
                FluidState fluidState = cache.getFluidState((Vec3i)offset);
                if (fluidState == FluidState.EMPTY || fluidState.getMaterial() == Material.field_151587_i) {
                    maxEncouragement = Math.max(blockEncouragement, maxEncouragement);
                    continue;
                }
                int fluidEncouragement = fluidState.getBlock().getFireSpreadSpeed((IBlockAccess)cache, offset, side.func_176734_d());
                if (fluidEncouragement == 0) {
                    if (FluidloggedAPIConfig.fluidStateIsFireInsulator) continue;
                    maxEncouragement = Math.max(blockEncouragement, maxEncouragement);
                    continue;
                }
                maxEncouragement = Math.max(blockEncouragement + fluidEncouragement, maxEncouragement);
            }
            return maxEncouragement;
        }
    }
}

