/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.modded.thermal_foundation;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.modded.cofhcore.PluginCoFHCore;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.impl.SpecializedFluidNeighborInfo;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginThermalFoundation
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if ("interactWithBlock".equals(method.name)) {
            return 1;
        }
        return method.name.equals(obfuscated ? "func_180650_b" : "updateTick") ? 2 : 0;
    }

    @Override
    public boolean transform(@Nonnull ClassNode classNode, @Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1) {
            if (this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "getFluidOrReal", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;"));
                instructions.remove(insn);
            } else if (this.checkMethod(insn, "isSideSolid", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Z")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("isHereSideSolid", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Z"));
                instructions.remove(insn);
            } else if (this.checkMethod(insn, "isFlammable")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("canCatchFire", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Z"));
                instructions.remove(insn);
            } else if (this.checkMethod(insn, obfuscated ? "func_175656_a" : "setBlockState", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("setBlockFromFluid", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z"));
                instructions.insert(insn, (AbstractInsnNode)new InsnNode(6));
                instructions.remove(insn);
            } else if (this.checkMethod(insn, obfuscated ? "func_180501_a" : "setBlockState", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("setBlockFromFluid", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z"));
                instructions.remove(insn);
            }
        } else if (index == 2) {
            if (this.checkMethod(insn, obfuscated ? "func_176201_c" : "getMetaFromState")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("falsify", "(I)I"));
            } else if (this.checkMethod(this.getNext(insn, 5), obfuscated ? "func_180650_b" : "updateTick")) {
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 2));
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 3));
                instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(178, classNode.name, "enableSourceFall", "Z"));
                instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("sourceFall", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Z)Z"));
                LabelNode label = new LabelNode();
                instructions.insertBefore(insn, (AbstractInsnNode)new JumpInsnNode(153, label));
                instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(177));
                instructions.insertBefore(insn, (AbstractInsnNode)label);
                instructions.insertBefore(insn, (AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        classNode.methods.removeIf(method -> method.name.equals("isEntityInsideMaterial"));
        return true;
    }

    public static final class Hooks {
        public static boolean areFluidsCompatible(@Nonnull Block block1, @Nonnull Block block2) {
            return FluidloggedUtils.isCompatibleFluid(FluidloggedUtils.getFluidFromBlock(block1), FluidloggedUtils.getFluidFromBlock(block2));
        }

        public static boolean canCatchFire(@Nonnull Block unused, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
            return world.func_82736_K().func_82766_b("doFireTick") && Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, pos, side);
        }

        public static boolean canSpreadFire(@Nonnull Block unused, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, @Nonnull FluidState state) {
            SpecializedFluidNeighborInfo.Forge info = new SpecializedFluidNeighborInfo.Forge((IBlockAccess)world, pos, state, 1);
            return info.canFlowInto(0, -side.func_96559_d(), 0, state.getMetadata(), side, false, false) && info.isVaporizable(0, 0, 0, state, side);
        }

        public static boolean isHereSideSolid(@Nonnull IBlockState unused, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
            return world.func_180495_p(pos).isSideSolid(world, pos, side);
        }

        public static boolean setBlockFromFluid(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int blockFlags) {
            return world.func_180501_a(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((World)world, (BlockPos)pos, (BlockPos)PluginCoFHCore.Hooks.fluid_pos_access.get(), (IBlockState)state), blockFlags);
        }

        public static boolean sourceFall(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean enabled) {
            if (enabled) {
                FluidState fluidState = FluidState.of(state);
                return fluidState.isSource() && Hooks.sourceFall(world, pos, state, fluidState, world.func_175726_f(pos));
            }
            return false;
        }

        public static boolean sourceFall(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull FluidState fluidState, @Nonnull Chunk chunk) {
            IBlockState here = chunk.func_177435_g(pos);
            if (FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos, here, fluidState.getDownDensityFace())) {
                IBlockState stateBelow;
                BlockPos offset = pos.func_177972_a(fluidState.getDownDensityFace());
                FluidState below = FluidloggedUtils.getFluidState(chunk, offset, stateBelow = chunk.func_177435_g(offset));
                if (FluidloggedUtils.isCompatibleFluid(fluidState, below) && !below.isSource()) {
                    if (FluidloggedUtils.isStateFluidloggable(stateBelow, (IBlockAccess)world, offset, fluidState)) {
                        if (FluidloggedUtils.canFluidFlow((IBlockAccess)world, offset, stateBelow, fluidState.getUpDensityFace())) {
                            FluidloggedUtils.setFluidState(world, offset, stateBelow, fluidState, false);
                            FluidloggedUtils.setFluidToAir(world, pos, here, 3);
                            return true;
                        }
                    } else if (stateBelow.func_177230_c().func_176200_f((IBlockAccess)world, offset)) {
                        world.func_175656_a(offset, state);
                        FluidloggedUtils.setFluidToAir(world, pos, here, 3);
                        return true;
                    }
                } else if (state.func_185904_a() == Material.field_151587_i && Blocks.field_150480_ab.func_176535_e((IBlockAccess)world, offset)) {
                    world.func_175656_a(offset, state);
                    FluidloggedUtils.setFluidToAir(world, pos, here, 3);
                    return true;
                }
            }
            return false;
        }

        public static int falsify(int i) {
            return 1;
        }
    }
}

