/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.modded.thermal_foundation;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.modded.thermal_foundation.PluginThermalFoundation;
import git.jbredwards.fluidlogged_api.mod.common.fluid.handler.FluidFlowHandler;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.impl.SpecializedFluidNeighborInfo;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public final class PluginThermalAerotheum
implements IASMPlugin {
    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/mod/asm/iface/IConditionalFluid");
        this.addMethod(classNode, "cannotFlowAt", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lgit/jbredwards/fluidlogged_api/api/util/FluidState;)Z", "cannotFlowAt", "(Lnet/minecraft/util/math/BlockPos;I)Z", generator -> {
            generator.visitVarInsn(25, 2);
            generator.visitFieldInsn(178, classNode.name, "maxHeight", "I");
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_180650_b" : "updateTick"), "update", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Ljava/util/Random;ZZI)V", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
            generator.visitFieldInsn(178, classNode.name, "enableSourceDissipate", "Z");
            generator.visitFieldInsn(178, classNode.name, "enableSourceFloat", "Z");
            generator.visitFieldInsn(178, classNode.name, "maxHeight", "I");
        });
        return false;
    }

    public static final class Hooks {
        public static boolean cannotFlowAt(@Nonnull BlockPos pos, int maxHeight) {
            return pos.func_177956_o() > maxHeight;
        }

        public static void update(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand, boolean dissipate, boolean doFloat, int maxHeight) {
            FluidState fluidState = FluidState.of(state);
            if (fluidState.isSource()) {
                int densityDir = fluidState.getDensityDir();
                if (dissipate && (pos.func_177956_o() + densityDir > maxHeight || (double)(pos.func_177956_o() + densityDir) > (double)maxHeight * 0.8 && new SpecializedFluidNeighborInfo.Forge((IBlockAccess)world, pos, fluidState, 0).canFlowInto(0, 0, 0, fluidState.getMetadata(), fluidState.getDownDensityFace(), true, false))) {
                    FluidloggedUtils.setFluidToAir(world, pos, null, 3);
                    return;
                }
                if (doFloat && rand.nextInt(3) == 0 && PluginThermalFoundation.Hooks.sourceFall(world, pos, state, fluidState, world.func_175726_f(pos))) {
                    return;
                }
            } else if (Hooks.cannotFlowAt(pos, maxHeight)) {
                FluidloggedUtils.setFluidToAir(world, pos, null, 3);
                return;
            }
            FluidFlowHandler.updateClassic(world, pos, fluidState);
        }
    }
}

