/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.forge;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.fluid.IFluidloggableFluid;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.forge.PluginBlockFluidBase;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.forge.PluginBlockFluidFinite;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.FluidCache;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginFluidUtil
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (this.checkMethod(method, "tryPickUpFluid", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Lnet/minecraftforge/fluids/FluidActionResult;")) {
            return 2;
        }
        return this.checkMethod(method, "tryPlaceFluid", "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraftforge/fluids/capability/IFluidHandler;Lnet/minecraftforge/fluids/FluidStack;)Z") ? 3 : 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 2 && this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState", null)) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "getFluidOrReal", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;"));
            instructions.remove(insn);
            return true;
        }
        if (index == 3 && this.checkMethod(insn, obfuscated ? "func_175623_d" : "isAirBlock", null)) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 4));
            list.add((AbstractInsnNode)new VarInsnNode(25, 6));
            list.add((AbstractInsnNode)this.genMethodNode("isFluidloggable", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraftforge/fluids/FluidStack;Lnet/minecraft/block/state/IBlockState;)Z"));
            instructions.insertBefore(insn, list);
            instructions.remove(insn);
            return true;
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, (MethodNode method) -> this.checkMethod((MethodNode)method, "getFluidHandler", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Lnet/minecraftforge/fluids/capability/IFluidHandler;"), "getFluidStateHandler", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Lnet/minecraftforge/fluids/capability/IFluidHandler;", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
        });
        return true;
    }

    public static final class Hooks {
        @Nullable
        public static IFluidHandler getFluidStateHandler(@Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
            FluidCache cache = new FluidCache((IBlockAccess)world, (Vec3i)pos, 0, 0);
            IBlockState state = cache.func_180495_p(pos);
            if (state.func_177230_c() instanceof IFluidBlock) {
                TileEntity tile = cache.func_175625_s(pos);
                return tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side) ? (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side) : new FluidBlockWrapper((IFluidBlock)state.func_177230_c(), world, pos);
            }
            FluidState fluidState = cache.getFluidState((Vec3i)pos);
            if (fluidState.isValid()) {
                return new FluidBlockWrapper(fluidState.getFluidBlock(), world, pos);
            }
            TileEntity tile = cache.func_175625_s(pos);
            return tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side) ? (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side) : null;
        }

        public static boolean isFluidloggable(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull FluidStack resource, @Nonnull IBlockState destBlockState) {
            Block block = resource.getFluid().getBlock();
            if (block instanceof IFluidloggableFluid) {
                if (!(block instanceof BlockFluidFinite)) {
                    return ((IFluidloggableFluid)block).isFluidloggableFluid(FluidState.of(block)) && ((IFluidloggableFluid)block).isStateFluidloggable(destBlockState, (IBlockAccess)world, pos, FluidState.of(block));
                }
                FluidState newState = (FluidState)((Object)PluginBlockFluidFinite.Hooks.getStateForStack((PluginBlockFluidBase.Accessor)block, (IBlockAccess)world, pos, resource, destBlockState).getKey());
                return !newState.isEmpty() && ((IFluidloggableFluid)block).isFluidloggableFluid(newState) && ((IFluidloggableFluid)block).isStateFluidloggable(destBlockState, (IBlockAccess)world, pos, newState);
            }
            return false;
        }
    }
}

