/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.forge;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.forge.PluginBlockFluidBase;
import git.jbredwards.fluidlogged_api.mod.common.fluid.handler.FluidFlowHandler;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.FluidCache;
import it.unimi.dsi.fastutil.objects.AbstractObject2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public final class PluginBlockFluidFinite
implements IASMPlugin {
    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/api/fluid/IFluidloggableFluid");
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("getQuantaValue"), null, null, (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitMethodInsn(184, "git/jbredwards/fluidlogged_api/mod/asm/plugins/forge/PluginBlockFluidClassic$Hooks", "getQuantaValue", "(Lnet/minecraftforge/fluids/IFluidBlock;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)I", false);
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_180650_b" : "updateTick"), "fluidUpdateTick", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Ljava/util/Random;)V", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("place"), "place", "(Lgit/jbredwards/fluidlogged_api/mod/asm/plugins/forge/PluginBlockFluidBase$Accessor;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraftforge/fluids/FluidStack;Z)I", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(21, 4);
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("drain"), "drain", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Z)Lnet/minecraftforge/fluids/FluidStack;", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(21, 3);
        });
        return false;
    }

    public static final class Hooks {
        public static void fluidUpdateTick(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
            FluidFlowHandler.updateFinite(world, pos, FluidState.of(state), rand);
        }

        @Nonnull
        public static FluidStack drain(@Nonnull World world, @Nonnull BlockPos pos, boolean doDrain) {
            FluidCache cache = new FluidCache((IBlockAccess)world, (Vec3i)pos, 0, 0);
            FluidStack stack = FluidloggedUtils.getFluidState(cache, pos).createFluidStack();
            if (doDrain) {
                FluidloggedUtils.setFluidToAir(world, pos, cache.func_180495_p(pos), 3);
            }
            return stack;
        }

        public static int place(@Nonnull PluginBlockFluidBase.Accessor block, @Nonnull World world, @Nonnull BlockPos pos, @Nullable FluidStack resource, boolean doPlace) {
            if (resource == null || resource.amount <= 0) {
                return 0;
            }
            FluidCache cache = new FluidCache((IBlockAccess)world, (Vec3i)pos, 1, 1);
            Object2IntMap.Entry<FluidState> placeInfo = Hooks.getStateForStack(block, cache, pos, resource, cache.func_180495_p(pos));
            if (((FluidState)((Object)placeInfo.getKey())).isEmpty()) {
                return 0;
            }
            if (doPlace && !world.field_72995_K) {
                if (world.field_73011_w.func_177500_n() && resource.getFluid().doesVaporize(resource)) {
                    FluidloggedUtils.playVaporizeEffects(world, pos, resource);
                } else if (FluidloggedUtils.isStateFluidloggable(cache.func_180495_p(pos), cache, pos, (FluidState)((Object)placeInfo.getKey()))) {
                    FluidloggedUtils.setFluidState(world, pos, cache.func_180495_p(pos), (FluidState)((Object)placeInfo.getKey()), false, 11);
                } else {
                    FluidUtil.destroyBlockOnFluidPlacement((World)world, (BlockPos)pos);
                    world.func_180501_a(pos, ((FluidState)((Object)placeInfo.getKey())).getState(), 11);
                }
            }
            return placeInfo.getIntValue();
        }

        @Nonnull
        public static Object2IntMap.Entry<FluidState> getStateForStack(@Nonnull PluginBlockFluidBase.Accessor block, @Nonnull IBlockAccess access, @Nonnull BlockPos pos, @Nonnull FluidStack resource, @Nonnull IBlockState here) {
            FluidState existing;
            if (resource.amount <= 0) {
                return new AbstractObject2IntMap.BasicEntry((Object)FluidState.EMPTY, 0);
            }
            float quantaAmount = 1000.0f / block.getQuantaPerBlockFloat_Public();
            int quantaPerBlock = block.getQuantaPerBlock_Public();
            int closest = 1000;
            int quanta = quantaPerBlock;
            if (resource.amount < closest) {
                closest = MathHelper.func_76141_d((float)(quantaAmount * (float)MathHelper.func_76141_d((float)((float)resource.amount / quantaAmount))));
                quanta = MathHelper.func_76141_d((float)((float)closest / quantaAmount));
            }
            if (FluidloggedUtils.isCompatibleFluid((existing = FluidloggedUtils.getFluidState(access, pos, here)).getFluid(), resource.getFluid())) {
                int existingQuanta = existing.getQuantaValue();
                int missingQuanta = quantaPerBlock - existingQuanta;
                closest = Math.min(closest, MathHelper.func_76141_d((float)((float)missingQuanta * quantaAmount)));
                quanta = Math.min(quanta + existingQuanta, quantaPerBlock);
            }
            if (quanta < 1 || quanta > 16) {
                return new AbstractObject2IntMap.BasicEntry((Object)FluidState.EMPTY, 0);
            }
            return new AbstractObject2IntMap.BasicEntry((Object)FluidState.of((Block)block).withLevel(quanta - 1), closest);
        }
    }
}

