/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.forge;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.fluid.IFluidloggableFluid;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.fluid.handler.FluidFlowHandler;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.FluidCache;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public final class PluginBlockFluidClassic
implements IASMPlugin {
    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/mod/asm/plugins/forge/PluginBlockFluidClassic$Accessor");
        this.addMethod(classNode, "canCreateSource_Public", "()Z", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidClassic", "canCreateSources", "Z");
        });
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/api/fluid/IFluidloggableFluid");
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("getQuantaValue"), "getQuantaValue", "(Lnet/minecraftforge/fluids/IFluidBlock;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)I", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_180650_b" : "updateTick"), "fluidUpdateTick", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)V", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("place"), "place", "(Lnet/minecraftforge/fluids/IFluidBlock;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraftforge/fluids/FluidStack;ZLnet/minecraft/block/state/IBlockState;)I", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(21, 4);
            generator.visitVarInsn(25, 0);
            generator.visitMethodInsn(182, "net/minecraft/block/Block", obfuscated ? "func_176223_P" : "getDefaultState", "()Lnet/minecraft/block/state/IBlockState;", false);
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("drain"), "drain", "(Lnet/minecraftforge/fluids/IFluidBlock;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;ZLnet/minecraftforge/fluids/FluidStack;)Lnet/minecraftforge/fluids/FluidStack;", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(21, 3);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidClassic", "stack", "Lnet/minecraftforge/fluids/FluidStack;");
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("isSourceBlock") || method.name.equals("canDrain"), "canDrain", "(Lnet/minecraftforge/fluids/IFluidBlock;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Z", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
        });
        return false;
    }

    public static interface Accessor {
        public boolean canCreateSource_Public();
    }

    public static final class Hooks {
        public static void fluidUpdateTick(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
            FluidFlowHandler.updateClassic(world, pos, FluidState.of(state));
        }

        public static boolean canDrain(@Nonnull IFluidBlock block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
            FluidState fluidState = FluidloggedUtils.getFluidState(world, pos);
            return FluidloggedUtils.isCompatibleFluid(fluidState.getFluid(), block.getFluid()) && fluidState.isSource();
        }

        @Nullable
        public static FluidStack drain(@Nonnull IFluidBlock block, @Nonnull World world, @Nonnull BlockPos pos, boolean doDrain, @Nullable FluidStack stack) {
            Chunk chunk = world.func_175726_f(pos);
            doDrain &= !world.field_72995_K;
            IBlockState here = chunk.func_177435_g(pos);
            if (FluidloggedUtils.isCompatibleFluid(FluidloggedUtils.getFluidFromState(here), block.getFluid())) {
                if (doDrain) {
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
                return (Integer)here.func_177229_b((IProperty)BlockLiquid.field_176367_b) > 0 ? null : (stack == null ? new FluidStack(block.getFluid(), 1000) : stack);
            }
            FluidState fluidState = FluidState.getFromProvider((ICapabilityProvider)chunk, pos);
            if (!FluidloggedUtils.isCompatibleFluid(fluidState.getFluid(), block.getFluid())) {
                return null;
            }
            if (doDrain) {
                FluidloggedUtils.setFluidState(world, pos, here, FluidState.EMPTY, false);
            }
            return !fluidState.isSource() ? null : (stack == null ? fluidState.createFluidStack() : stack.copy());
        }

        public static int getQuantaValue(@Nonnull IFluidBlock block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
            FluidCache cache = new FluidCache(world, (Vec3i)pos, 0, 1);
            FluidState fluidState = FluidloggedUtils.getFluidState(cache, pos);
            return FluidloggedUtils.isCompatibleFluid(fluidState.getFluid(), block.getFluid()) ? fluidState.getQuantaValue() : (cache.func_175623_d(pos) ? 0 : -1);
        }

        public static int place(@Nonnull IFluidBlock block, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull FluidStack fluidStack, boolean doPlace, @Nonnull IBlockState defaultState) {
            if (fluidStack.amount < 1000) {
                return 0;
            }
            if (world.field_73011_w.func_177500_n() && fluidStack.getFluid().doesVaporize(fluidStack)) {
                FluidloggedUtils.playVaporizeEffects(world, pos, fluidStack);
            } else if (doPlace && !world.field_72995_K) {
                IBlockState here;
                FluidState fluidState = FluidState.of(defaultState).toFlowing();
                Chunk chunk = world.func_175726_f(pos);
                FluidState fluidHere = FluidloggedUtils.getFluidState(chunk, pos, here = chunk.func_177435_g(pos));
                if (fluidHere.getFluid() == fluidState.getFluid() && fluidHere.getLevel() == fluidState.getLevel() || fluidHere.getBlock() instanceof IFluidloggableFluid && !((IFluidloggableFluid)fluidHere.getBlock()).isReplaceableByOther(world, fluidHere, fluidState, true)) {
                    return 1000;
                }
                IFluidloggableFluid handler = (IFluidloggableFluid)block;
                if (handler.isFluidloggableFluid(fluidState) && handler.isStateFluidloggable(here, (IBlockAccess)world, pos, fluidState) && FluidloggedUtils.setFluidState(world, pos, here, fluidState, true)) {
                    return 1000;
                }
                FluidUtil.destroyBlockOnFluidPlacement((World)world, (BlockPos)pos);
                world.func_180501_a(pos, fluidState.getState(), 11);
            }
            return 1000;
        }
    }
}

