/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.iface;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;

@FunctionalInterface
public interface ICanFluidFlowHandler {
    @Nonnull
    public static final ICanFluidFlowHandler ALWAYS_FLOW = (world, pos, state, side) -> true;
    @Nonnull
    public static final ICanFluidFlowHandler NEVER_FLOW = (world, pos, state, side) -> false;
    @Nonnull
    public static final ICanFluidFlowHandler DEPRECATED_CHECK = (world, pos, state, side) -> !state.isSideSolid(world, pos, side);

    @Nonnull
    default public ICanFluidFlowHandler negate() {
        return (world, pos, state, side) -> !this.canFluidFlow(world, pos, state, side);
    }

    public boolean canFluidFlow(@Nonnull IBlockAccess var1, @Nonnull BlockPos var2, @Nonnull IBlockState var3, @Nonnull EnumFacing var4);

    public static interface Accessor {
        @Nullable
        public ICanFluidFlowHandler getCanFluidFlowOverride();

        @Nullable
        public static ICanFluidFlowHandler getOverride(@Nonnull IBlockState state) {
            if (state instanceof IExtendedBlockState) {
                state = ((IExtendedBlockState)state).getClean();
            }
            return ((Accessor)state).getCanFluidFlowOverride();
        }

        public void setCanFluidFlowOverride(@Nullable ICanFluidFlowHandler var1);

        public static void setOverride(@Nonnull Object state, @Nullable ICanFluidFlowHandler override) {
            if (state instanceof IExtendedBlockState) {
                state = ((IExtendedBlockState)state).getClean();
            }
            ((Accessor)state).setCanFluidFlowOverride(override);
        }
    }
}

