/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.api.util;

import git.jbredwards.fluidlogged_api.api.capability.IFluidStateCapability;
import git.jbredwards.fluidlogged_api.api.fluid.IFlowCostFluid;
import git.jbredwards.fluidlogged_api.api.fluid.IFluidloggableFluid;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.api.world.IFluidStateProvider;
import git.jbredwards.fluidlogged_api.api.world.IWorldProvider;
import git.jbredwards.fluidlogged_api.mod.asm.iface.IDefaultFluidState;
import git.jbredwards.fluidlogged_api.mod.asm.iface.ILevelFluidStateLookup;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.forge.PluginBlockFluidBase;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.FluidCache;
import io.netty.util.internal.IntegerHolder;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.BlockStateContainer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@Immutable
public class FluidState
extends Pair<Fluid, IBlockState>
implements Object2ObjectMap.Entry<Fluid, IBlockState> {
    @Nonnull
    public static final ThreadLocal<Object> removeOnBlockChange = new ThreadLocal();
    @Nonnull
    public static final FluidState EMPTY = new EmptyFluidState();
    protected final Fluid fluid;
    protected final IBlockState state;
    protected byte level = (byte)-1;
    protected byte meta = (byte)-1;
    protected float fluidHeight = Float.MAX_VALUE;
    protected int propsKey = -1;

    protected FluidState(@Nullable Fluid fluidIn, IBlockState stateIn) {
        this.fluid = fluidIn;
        this.state = stateIn;
    }

    @Nonnull
    public static FluidState of(@Nullable Fluid fluid) {
        return fluid != null ? FluidState.of(fluid.getBlock()) : EMPTY;
    }

    @Nonnull
    public static FluidState of(@Nullable Block block) {
        return block != null ? FluidState.of(block.func_176223_P()) : EMPTY;
    }

    @Nonnull
    public static FluidState of(@Nullable IBlockState stateIn) {
        if (stateIn == null) {
            return EMPTY;
        }
        IBlockState state = stateIn instanceof IExtendedBlockState ? ((IExtendedBlockState)stateIn).getClean() : stateIn;
        FluidState defaultFluidState = ((IDefaultFluidState)state).getDefaultFluidState();
        if (defaultFluidState != null) {
            return defaultFluidState;
        }
        Fluid fluid = FluidloggedUtils.getFluidFromState(state);
        if (fluid == null) {
            ((IDefaultFluidState)state).setDefaultFluidState(EMPTY);
            return EMPTY;
        }
        FluidState fluidState = fluid.getBlock() != state.func_177230_c() && !(fluid.getBlock() instanceof BlockLiquid) && fluid.getBlock() instanceof IFluidBlock ? FluidState.of(fluid).withLevel((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b)) : new FluidState(fluid, state);
        ((IDefaultFluidState)state).setDefaultFluidState(fluidState);
        return fluidState;
    }

    @Nonnull
    public static FluidState get(@Nullable IBlockAccess world, int x, int y, int z) {
        return world instanceof IFluidStateProvider ? ((IFluidStateProvider)world).getFluidState(x, y, z) : EMPTY;
    }

    @Nonnull
    public static FluidState get(@Nullable IBlockAccess world, @Nonnull BlockPos pos) {
        return FluidState.get(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public static FluidState get(@Nonnull BlockPos pos) {
        return FluidState.get((IBlockAccess)IWorldProvider.getWorldClient(), pos);
    }

    @Nonnull
    public static FluidState getFromProvider(@Nullable ICapabilityProvider provider, int x, int y, int z) {
        IFluidStateCapability cap = IFluidStateCapability.get(provider);
        return cap == null ? EMPTY : cap.getContainer(y).getFluidState(x, y, z, EMPTY);
    }

    @Nonnull
    public static FluidState getFromProvider(@Nullable ICapabilityProvider provider, @Nonnull BlockPos pos) {
        return FluidState.getFromProvider(provider, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Nonnull
    public static FluidState deserialize(int serialized) {
        return FluidState.of((IBlockState)Block.field_176229_d.func_148745_a(serialized));
    }

    public int serialize() {
        return Block.field_176229_d.func_148747_b((Object)this.getState());
    }

    public boolean isEmpty() {
        return false;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    @Nonnull
    public IBlockState getState() {
        return this.state;
    }

    public int getMetadata() {
        return this.meta != -1 ? this.meta : (this.meta = (byte)this.getBlock().func_176201_c(this.getState()));
    }

    public final boolean isValid() {
        return this.getBlock() instanceof IFluidBlock;
    }

    @Nonnull
    public final IFluidBlock getFluidBlock() {
        return (IFluidBlock)this.getBlock();
    }

    public final boolean isFluidloggable() {
        return this.getBlock() instanceof IFluidloggableFluid && this.getFluidBlockHandler().isFluidloggableFluid(this);
    }

    @Nonnull
    public final IFluidloggableFluid getFluidBlockHandler() {
        return (IFluidloggableFluid)this.getBlock();
    }

    @Nonnull
    public Block getBlock() {
        return this.getState().func_177230_c();
    }

    @Nonnull
    public Material getMaterial() {
        return this.getState().func_185904_a();
    }

    public int getLevel() {
        return this.level != -1 ? this.level : (this.level = ((Integer)this.getState().func_177229_b((IProperty)BlockLiquid.field_176367_b)).byteValue());
    }

    public int getWrappedLevel(@Nonnull World world) {
        return this.getBlock() instanceof BlockLiquid && this.getLevel() >= 8 ? this.getFlowCost(world) : this.getLevel();
    }

    public boolean isSource() {
        return this.isValid() && this.getLevel() == (this.getBlock() instanceof BlockFluidFinite ? this.getQuantaPerBlock() - 1 : 0);
    }

    @Nonnull
    public FluidState toSource() {
        return this.withLevel(0);
    }

    @Nonnull
    public FluidState withLevel(int level) {
        ILevelFluidStateLookup lookup = (ILevelFluidStateLookup)this.getBlock().func_176194_O();
        if (lookup.getFluidStateLookup() == null) {
            this.buildFluidLevelLookup(lookup);
        }
        return lookup.getFluidStateLookup()[this.propsKey][level];
    }

    @Nonnull
    public FluidState addLevel(int toAdd) {
        if (this.getBlock() instanceof BlockFluidFinite) {
            return this.withLevel(Math.max(this.getLevel() - toAdd, 0));
        }
        return this.withLevel(MathHelper.func_76125_a((int)(this.getLevel() + toAdd), (int)0, (int)(this.getQuantaPerBlock() - 1)));
    }

    @Nonnull
    public FluidState toFlowing() {
        return this.getBlock() instanceof BlockStaticLiquid ? FluidState.of((Block)BlockLiquid.func_176361_a((Material)this.getMaterial())).withLevel(this.getLevel()) : this;
    }

    @Nonnull
    public FluidState toStatic() {
        return this.getBlock() instanceof BlockDynamicLiquid ? FluidState.of((Block)BlockLiquid.func_176363_b((Material)this.getMaterial())).withLevel(this.getLevel()) : this;
    }

    public float getQuantaFraction() {
        return this.getBlock() instanceof PluginBlockFluidBase.Accessor ? ((PluginBlockFluidBase.Accessor)this.getBlock()).getQuantaFraction_Public() : 0.8888889f;
    }

    public int getQuantaPerBlock() {
        return this.getBlock() instanceof PluginBlockFluidBase.Accessor ? ((PluginBlockFluidBase.Accessor)this.getBlock()).getQuantaPerBlock_Public() : 8;
    }

    public float getQuantaPerBlockFloat() {
        return this.getBlock() instanceof PluginBlockFluidBase.Accessor ? ((PluginBlockFluidBase.Accessor)this.getBlock()).getQuantaPerBlockFloat_Public() : 8.0f;
    }

    public int getQuantaValue() {
        return this.getBlock() instanceof BlockFluidFinite ? this.getLevel() + 1 : this.getQuantaPerBlock() - this.getLevel();
    }

    public final int getQuantaValue(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        IBlockAccess access;
        IBlockAccess iBlockAccess = access = world instanceof World ? new FluidCache(world, (Vec3i)pos, 0, 0) : world;
        if (access.func_175623_d(pos)) {
            return 0;
        }
        FluidState fluidState = FluidloggedUtils.getFluidState(access, pos);
        return FluidloggedUtils.isCompatibleFluid(this, fluidState) ? fluidState.getQuantaValue() : -1;
    }

    public final int getQuantaValueAbove(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        return quantaRemaining <= aboveThis ? -1 : quantaRemaining;
    }

    public final int getQuantaValueBelow(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        return quantaRemaining >= belowThis ? -1 : quantaRemaining;
    }

    public int getFlowCost(@Nonnull World world) {
        return this.getBlock() instanceof IFlowCostFluid ? ((IFlowCostFluid)this.getBlock()).getFlowCost(this, world) : 1;
    }

    public int getDensity() {
        return this.getBlock() instanceof BlockFluidBase ? ((BlockFluidBase)this.getBlock()).getDensity() : this.getFluid().getDensity();
    }

    public int getTemperature() {
        return this.getBlock() instanceof BlockFluidBase ? ((BlockFluidBase)this.getBlock()).getTemperature() : this.getFluid().getTemperature();
    }

    public int getDensityDir() {
        return this.getBlock() instanceof PluginBlockFluidBase.Accessor ? ((PluginBlockFluidBase.Accessor)this.getBlock()).getDensityDir_Public() : -1;
    }

    @Nonnull
    public Map<Block, Boolean> getDisplacements() {
        return this.getBlock() instanceof PluginBlockFluidBase.Accessor ? ((PluginBlockFluidBase.Accessor)this.getBlock()).getDisplacements_Public() : Collections.emptyMap();
    }

    public float getHeight() {
        if (this.fluidHeight != Float.MAX_VALUE) {
            return this.fluidHeight;
        }
        if (this.getBlock() instanceof BlockLiquid) {
            this.fluidHeight = 1.0f - BlockLiquid.func_149801_b((int)(this.getLevel() >= 8 ? 1 : this.getLevel()));
            return this.fluidHeight;
        }
        if (this.isValid()) {
            this.fluidHeight = (float)this.getQuantaValue() * this.getQuantaFraction() / this.getQuantaPerBlockFloat();
            return this.fluidHeight;
        }
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("Cannot get fluid height from empty FluidState!");
        }
        this.fluidHeight = this.getQuantaFraction();
        return this.fluidHeight;
    }

    public float getActualHeight(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        IBlockAccess access = world instanceof World ? new FluidCache(world, (Vec3i)pos, 1, 1) : world;
        EnumFacing side = this.getUpDensityFace();
        if (FluidloggedUtils.canFluidFlow(access, pos, access.func_180495_p(pos), side)) {
            IBlockState above;
            BlockPos offset = pos.func_177972_a(side);
            return FluidloggedUtils.canFluidFlow(access, offset, above = access.func_180495_p(offset), side.func_176734_d()) && FluidloggedUtils.isCompatibleFluid(FluidloggedUtils.getFluidState(access, offset, above), this) ? 1.0f : this.getHeight();
        }
        return this.getHeight();
    }

    @Nonnull
    public AxisAlignedBB getFluidBox(@Nonnull IBlockAccess access, @Nonnull BlockPos pos) {
        double fluidHeight = this.getActualHeight(access, pos);
        return this.getFluid().isLighterThanAir() ? new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1) - fluidHeight, (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)) : new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)pos.func_177956_o() + fluidHeight, (double)(pos.func_177952_p() + 1));
    }

    @Nonnull
    public FluidStack createFluidStack() {
        if (this.getBlock() instanceof BlockFluidFinite) {
            return new FluidStack(this.getFluid(), MathHelper.func_76141_d((float)((float)this.getQuantaValue() / this.getQuantaPerBlockFloat() * 1000.0f)));
        }
        return new FluidStack(this.getFluid(), this.isSource() ? 1000 : 0);
    }

    @Nonnull
    public EnumFacing getDownDensityFace() {
        return this.getDensityDir() < 0 ? EnumFacing.DOWN : EnumFacing.UP;
    }

    @Nonnull
    public EnumFacing getUpDensityFace() {
        return this.getDensityDir() < 0 ? EnumFacing.UP : EnumFacing.DOWN;
    }

    protected final synchronized void buildFluidLevelLookup(@Nonnull ILevelFluidStateLookup lookup) {
        if (lookup.getFluidStateLookup() == null) {
            IBlockState[] states = (IBlockState[])this.getBlock().func_176194_O().func_177619_a().stream().filter(stateIn -> FluidState.of(stateIn).getLevel() == 0).toArray(IBlockState[]::new);
            FluidState[][] fluidStateLookup = new FluidState[states.length][BlockLiquid.field_176367_b.func_177700_c().size()];
            IntegerHolder stateId = new IntegerHolder();
            while (stateId.value < states.length) {
                BlockLiquid.field_176367_b.func_177700_c().forEach(lvl -> {
                    FluidState withLevel;
                    fluidStateLookup[stateId.value][lvl.intValue()] = withLevel = FluidState.of(states[stateId.value].func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)lvl));
                    if (this.getBlock() == withLevel.getBlock()) {
                        withLevel.propsKey = stateId.value;
                    }
                });
                ++stateId.value;
            }
            lookup.setFluidStateLookup(fluidStateLookup);
        }
    }

    public final Fluid getLeft() {
        return this.getFluid();
    }

    public final IBlockState getRight() {
        return this.getState();
    }

    public final IBlockState getValue() {
        return this.getState();
    }

    public final IBlockState setValue(@Nullable IBlockState value) {
        throw new UnsupportedOperationException();
    }

    private static final class EmptyFluidState
    extends FluidState {
        EmptyFluidState() {
            super(null, null);
            this.fluidHeight = 0.0f;
        }

        @Override
        @Nonnull
        public IBlockState getState() {
            return BlockStateContainer.field_186020_a;
        }

        @Override
        public int serialize() {
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int getLevel() {
            throw new UnsupportedOperationException("Cannot get level from empty FluidState!");
        }

        @Override
        public int getDensityDir() {
            throw new UnsupportedOperationException("Cannot get densityDir from empty FluidState!");
        }

        @Override
        public float getQuantaFraction() {
            throw new UnsupportedOperationException("Cannot get quantaFraction from empty FluidState!");
        }

        @Override
        public int getQuantaPerBlock() {
            throw new UnsupportedOperationException("Cannot get quantaPerBlock from empty FluidState!");
        }

        @Override
        public float getQuantaPerBlockFloat() {
            throw new UnsupportedOperationException("Cannot get quantaPerBlockFloat from empty FluidState!");
        }

        @Override
        @Nonnull
        public FluidState withLevel(int level) {
            throw new UnsupportedOperationException("Cannot apply level to empty FluidState!");
        }

        @Override
        @Nonnull
        public AxisAlignedBB getFluidBox(@Nonnull IBlockAccess access, @Nonnull BlockPos pos) {
            throw new UnsupportedOperationException("Cannot get box from empty FluidState!");
        }
    }
}

