/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.api.network;

import com.google.gson.JsonElement;
import com.google.gson.internal.bind.TypeAdapters;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public final class MessageUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static JsonElement readJson(@Nonnull ByteBuf buf) {
        ByteBufInputStream is = new ByteBufInputStream(buf, buf.readInt());
        try (InputStreamReader reader = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);){
            JsonElement jsonElement = (JsonElement)TypeAdapters.JSON_ELEMENT.fromJson((Reader)reader);
            return jsonElement;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static ByteBuf writeJson(@Nonnull ByteBuf buf, @Nonnull JsonElement json) {
        int startIndex = buf.writerIndex();
        ByteBufOutputStream os = new ByteBufOutputStream(buf.writeInt(0));
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);){
            TypeAdapters.JSON_ELEMENT.toJson((Writer)writer, (Object)json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buf.setInt(startIndex, buf.writerIndex() - startIndex - 4);
    }

    public static void sendToAllTracking(@Nonnull IMessage message, @Nonnull Chunk chunk, @Nonnull SimpleNetworkWrapper networkWrapper) {
        MessageUtils.sendToAllTracking(message, chunk, (arg_0, arg_1) -> ((SimpleNetworkWrapper)networkWrapper).sendTo(arg_0, arg_1));
    }

    public static void sendToAllTracking(@Nonnull IMessage message, @Nonnull Chunk chunk, @Nonnull BiConsumer<IMessage, EntityPlayerMP> networkWrapper) {
        PlayerChunkMapEntry entry;
        if (chunk.func_177412_p() instanceof WorldServer && (entry = ((WorldServer)chunk.func_177412_p()).func_184164_w().func_187301_b(chunk.field_76635_g, chunk.field_76647_h)) != null) {
            entry.getWatchingPlayers().forEach(player -> networkWrapper.accept(message, (EntityPlayerMP)player));
        }
    }

    public static void sendToAllTracking(@Nonnull IMessage message, @Nonnull TileEntity tile, @Nonnull SimpleNetworkWrapper networkWrapper) {
        MessageUtils.sendToAllTracking(message, tile, (arg_0, arg_1) -> ((SimpleNetworkWrapper)networkWrapper).sendTo(arg_0, arg_1));
    }

    public static void sendToAllTracking(@Nonnull IMessage message, @Nonnull TileEntity tile, @Nonnull BiConsumer<IMessage, EntityPlayerMP> networkWrapper) {
        PlayerChunkMapEntry entry;
        if (tile.func_145830_o() && tile.func_145831_w() instanceof WorldServer && (entry = ((WorldServer)tile.func_145831_w()).func_184164_w().func_187301_b(tile.func_174877_v().func_177958_n() >> 4, tile.func_174877_v().func_177952_p() >> 4)) != null) {
            entry.getWatchingPlayers().forEach(player -> networkWrapper.accept(message, (EntityPlayerMP)player));
        }
    }
}

