/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.api.fluid;

import git.jbredwards.fluidlogged_api.api.block.IFluidloggable;
import git.jbredwards.fluidlogged_api.api.event.FluidloggableEvent;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public interface IFluidloggableFluid {
    default public boolean isFluidloggableFluid(@Nonnull FluidState fluidState) {
        return fluidState.isValid() && !fluidState.getBlock().hasTileEntity(fluidState.getState());
    }

    default public boolean isReplaceableByOther(@Nonnull World world, @Nonnull FluidState fluidState, @Nonnull FluidState other, boolean allowMatching) {
        if (allowMatching && FluidloggedUtils.isCompatibleFluid(fluidState, other) || other.isSource()) {
            return true;
        }
        if (fluidState.isSource()) {
            return false;
        }
        int hereDensity = fluidState.withLevel(fluidState.getWrappedLevel(world)).getQuantaValue() * fluidState.getDensity();
        int otherDensity = other.withLevel(other.getWrappedLevel(world)).getQuantaValue() * other.getDensity();
        return allowMatching ? hereDensity <= otherDensity : hereDensity < otherDensity;
    }

    default public boolean isStateFluidloggable(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull FluidState fluidState) {
        if (state.func_177230_c().isAir(state, world, pos) || state.func_177230_c() instanceof IFluidloggableFluid || FluidloggedUtils.isFluid(state)) {
            return false;
        }
        FluidloggableEvent event = new FluidloggableEvent(state, world, pos, fluidState);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() != Event.Result.DEFAULT) {
            return event.getResult() == Event.Result.ALLOW;
        }
        return state.func_177230_c() instanceof IFluidloggable && (FluidloggedAPIConfig.allowDefaults || ((IFluidloggable)state.func_177230_c()).overrideApplyDefaultsSetting()) && ((IFluidloggable)state.func_177230_c()).isFluidloggable(state, world, pos, fluidState);
    }
}

