/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.api.generation;

import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.api.generation.Generators;
import biomesoplenty.api.generation.IGenerator;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class BOPGeneratorBase
extends WorldGenerator
implements IGenerator {
    protected final String identifier = Generators.registry.getIdentifier(this.getClass());
    protected String name;
    protected GeneratorStage stage;
    protected float amountPerChunk;

    protected BOPGeneratorBase(float amountPerChunk) {
        if (this.identifier == null) {
            throw new RuntimeException("The identifier for " + this.getClass().getCanonicalName() + " cannot be null!");
        }
        this.amountPerChunk = amountPerChunk;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setStage(GeneratorStage stage) {
        this.stage = stage;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public GeneratorStage getStage() {
        return this.stage;
    }

    @Override
    public final String getIdentifier() {
        return this.identifier;
    }

    public abstract BlockPos getScatterY(World var1, Random var2, int var3, int var4);

    public int getAmountToScatter(Random random) {
        int amount = MathHelper.func_76141_d((float)this.amountPerChunk);
        float remainder = this.amountPerChunk - (float)amount;
        if (random.nextFloat() < remainder) {
            ++amount;
        }
        return amount;
    }

    @Override
    public void scatter(World world, Random random, BlockPos pos) {
        int amount = this.getAmountToScatter(random);
        for (int i = 0; i < amount; ++i) {
            int x = pos.func_177958_n() + random.nextInt(16) + 8;
            int z = pos.func_177952_p() + random.nextInt(16) + 8;
            this.func_180709_b(world, random, this.getScatterY(world, random, x, z));
        }
    }

    protected static abstract class InnerBuilder<T extends InnerBuilder<T, G>, G extends BOPGeneratorBase> {
        protected float amountPerChunk;

        protected InnerBuilder() {
        }

        protected T self() {
            return (T)this;
        }

        public T amountPerChunk(float amountPerChunk) {
            this.amountPerChunk = amountPerChunk;
            return this.self();
        }

        public abstract G create();
    }
}

