/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.integration.artemislib;

import com.artemis.artemislib.compatibilities.sizeCap.ISizeCap;
import com.artemis.artemislib.compatibilities.sizeCap.SizeCapPro;
import com.artemis.artemislib.util.AttachAttributes;
import com.artemis.artemislib.util.attributes.ArtemisLibAttributes;
import com.fuzs.aquaacrobatics.entity.Pose;
import com.fuzs.aquaacrobatics.entity.player.IPlayerResizeable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class AttachAttributesFix
extends AttachAttributes {
    private boolean isResizingRequired;

    @SubscribeEvent
    public void attachAttributes(EntityEvent.EntityConstructing evt) {
        super.attachAttributes(evt);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        super.onPlayerTick(evt);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent evt) {
        super.onLivingUpdate(evt);
    }

    @SubscribeEvent
    public void onEntityRenderPre(RenderLivingEvent.Pre evt) {
        EntityLivingBase entity = evt.getEntity();
        this.updateResizingFlag(entity);
        if (this.isResizingRequired) {
            double widthAttribute = entity.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_WIDTH).func_111126_e();
            double heightAttribute = entity.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_HEIGHT).func_111126_e();
            if (entity instanceof IPlayerResizeable && ((IPlayerResizeable)entity).getPose() == Pose.SWIMMING && ((IPlayerResizeable)entity).getSwimAnimation(evt.getPartialRenderTick()) > 0.0f) {
                heightAttribute *= 3.0;
            }
            widthAttribute = Math.max(widthAttribute, (double)0.15f);
            heightAttribute = Math.max(heightAttribute, 0.25);
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)widthAttribute, (double)heightAttribute, (double)widthAttribute);
            GlStateManager.func_179137_b((double)(evt.getX() / widthAttribute - evt.getX()), (double)(evt.getY() / heightAttribute - evt.getY()), (double)(evt.getZ() / widthAttribute - evt.getZ()));
        }
    }

    @SubscribeEvent
    public void onLivingRenderPost(RenderLivingEvent.Post evt) {
        if (this.isResizingRequired) {
            GlStateManager.func_179121_F();
        }
    }

    private void updateResizingFlag(EntityLivingBase entity) {
        ISizeCap cap;
        if (entity.hasCapability(SizeCapPro.sizeCapability, null) && (cap = (ISizeCap)entity.getCapability(SizeCapPro.sizeCapability, null)) != null && cap.getTrans()) {
            boolean isWidthModified = !entity.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_WIDTH).func_111122_c().isEmpty();
            boolean isHeightModified = !entity.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_HEIGHT).func_111122_c().isEmpty();
            this.isResizingRequired = isWidthModified || isHeightModified;
            return;
        }
        this.isResizingRequired = false;
    }
}

